/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.ContentLengthHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import java.io.IOException;

public interface ContentLengthHeader
extends SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Content-Length");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"l");

    public int getContentLength();

    @Override
    public ContentLengthHeader clone();

    public static ContentLengthHeader create(int contentLength) {
        PreConditions.assertArgument(contentLength >= 0, "The value must be greater or equal to zero");
        return new ContentLengthHeaderImpl(contentLength);
    }

    public static ContentLengthHeader frame(Buffer buffer) throws SipParseException {
        try {
            int value = buffer.parseToInt();
            return new ContentLengthHeaderImpl(value);
        }
        catch (NumberFormatException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Content-Length header. Value is not an integer");
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Expires header. Got an IOException", e);
        }
    }

    @Override
    public Builder copy();

    @Override
    default public boolean isContentLengthHeader() {
        return true;
    }

    @Override
    default public ContentLengthHeader toContentLengthHeader() {
        return this;
    }

    public static class Builder
    implements SipHeader.Builder<ContentLengthHeader> {
        private int value;

        public Builder() {
        }

        public Builder(int value) {
            this.value = value;
        }

        public Builder withValue(int value) {
            this.value = value;
            return this;
        }

        @Override
        public SipHeader.Builder<ContentLengthHeader> withValue(Buffer value) {
            throw new RuntimeException("TODO: not implemented yet");
        }

        @Override
        public ContentLengthHeader build() throws SipParseException {
            PreConditions.assertArgument(this.value >= 0, "The value must be greater or equal to zero");
            return new ContentLengthHeaderImpl(this.value);
        }
    }
}

