/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.SipResponseBuilder;

public interface SipResponse
extends SipMessage {
    public int getStatus();

    public Buffer getReasonPhrase();

    @Override
    default public boolean isResponse() {
        return true;
    }

    default public boolean isError() {
        return this.getStatus() / 100 >= 4;
    }

    default public boolean isProvisional() {
        return this.getStatus() / 100 == 1;
    }

    default public boolean isFinal() {
        return this.getStatus() >= 200;
    }

    default public boolean isSuccess() {
        return this.getStatus() / 100 == 2;
    }

    default public boolean isRedirect() {
        return this.getStatus() / 100 == 3;
    }

    default public boolean isClientError() {
        return this.getStatus() / 100 == 4;
    }

    default public boolean isServerError() {
        return this.getStatus() / 100 == 5;
    }

    default public boolean isGlobalError() {
        return this.getStatus() / 100 == 6;
    }

    default public boolean is100Trying() {
        return this.getStatus() == 100;
    }

    default public boolean isRinging() {
        return this.getStatus() == 180 || this.getStatus() == 183;
    }

    public static Builder withStatusCode(int statusCode) {
        return new SipResponseBuilder(statusCode);
    }

    default public boolean isTimeout() {
        return this.getStatus() == 480;
    }

    @Override
    default public SipResponse toResponse() throws ClassCastException {
        return this;
    }

    default public ViaHeader popViaHeader() throws SipParseException {
        throw new RuntimeException("No longer allowed because I'm immutable");
    }

    public Builder copy();

    @Override
    public SipResponse clone();

    public static interface Builder
    extends SipMessage.Builder<SipResponse> {
        @Override
        default public SipMessage.Builder<SipResponse> toSipResponseBuilder() {
            return this;
        }

        @Override
        default public boolean isSipResponseBuilder() {
            return true;
        }

        public Builder withReasonPhrase(String var1);

        public Builder withReasonPhrase(Buffer var1);

        @Override
        public SipResponse build();
    }
}

