/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipParser;

public final class SipResponseLine
extends SipInitialLine {
    private final int statusCode;
    private final Buffer reason;
    private Buffer responseLine;

    public SipResponseLine(int statusCode, Buffer reason) {
        assert (reason != null);
        this.statusCode = statusCode;
        this.reason = reason;
    }

    @Override
    public boolean isResponseLine() {
        return true;
    }

    @Override
    public SipResponseLine toResponseLine() {
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Buffer getReason() {
        return this.reason;
    }

    @Override
    public Buffer getBuffer() {
        if (this.responseLine == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("SIP/2.0 ").append(this.statusCode).append(" ").append(this.reason.toString());
            this.responseLine = Buffers.wrap((String)sb.toString());
        }
        return this.responseLine;
    }

    @Override
    public SipResponseLine clone() {
        return new SipResponseLine(this.statusCode, this.reason.clone());
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    @Override
    public void getBytes(Buffer dst) {
        SipParser.SIP2_0.getBytes(0, dst);
        dst.write((byte)32);
        dst.writeAsString(this.statusCode);
        dst.write((byte)32);
        this.reason.getBytes(0, dst);
    }
}

