/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.SipMessageImpl;
import io.pkts.packet.sip.impl.SipResponseLine;

public final class SipResponseImpl
extends SipMessageImpl
implements SipResponse {
    private CSeqHeader cseq;

    public SipResponseImpl(Buffer initialLine, Buffer headers, Buffer payload) {
        super(initialLine, headers, payload);
    }

    public SipResponseImpl(SipResponseLine initialLine, Buffer headers, Buffer payload) {
        super(initialLine, headers, payload);
    }

    @Override
    public Buffer getReasonPhrase() {
        return this.getResponseLine().getReason().slice();
    }

    @Override
    public Buffer getMethod() throws SipParseException {
        return this.getCSeqHeader().getMethod();
    }

    @Override
    public int getStatus() {
        return this.getResponseLine().getStatusCode();
    }

    @Override
    public boolean isProvisional() {
        return this.getStatus() / 100 == 1;
    }

    @Override
    public boolean isFinal() {
        return this.getStatus() >= 200;
    }

    @Override
    public boolean isSuccess() {
        return this.getStatus() / 100 == 2;
    }

    @Override
    public boolean isRedirect() {
        return this.getStatus() / 100 == 3;
    }

    @Override
    public boolean isClientError() {
        return this.getStatus() / 100 == 4;
    }

    @Override
    public boolean isServerError() {
        return this.getStatus() / 100 == 5;
    }

    @Override
    public boolean isGlobalError() {
        return this.getStatus() / 100 == 6;
    }

    @Override
    public boolean is100Trying() {
        return this.getStatus() == 100;
    }

    @Override
    public boolean isRinging() {
        return this.getStatus() == 180 || this.getStatus() == 183;
    }

    @Override
    public boolean isTimeout() {
        return this.getStatus() == 480;
    }

    @Override
    public SipResponse toResponse() throws ClassCastException {
        return this;
    }

    @Override
    public SipResponse clone() {
        throw new RuntimeException("Sorry, not implemented right now");
    }

    @Override
    public ViaHeader popViaHeader() throws SipParseException {
        SipHeader header = this.popHeader(ViaHeader.NAME);
        if (header instanceof ViaHeader) {
            return (ViaHeader)header;
        }
        if (header == null) {
            return null;
        }
        Buffer buffer = header.getValue();
        return ViaHeader.frame(buffer);
    }
}

