/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.SipMessageImpl;
import io.pkts.packet.sip.impl.SipRequestLine;
import io.pkts.packet.sip.impl.SipResponseImpl;
import io.pkts.packet.sip.impl.SipResponseLine;

public final class SipRequestImpl
extends SipMessageImpl
implements SipRequest {
    private static final Buffer[] DEFAULT_RESPONSE_REASON = new Buffer[700];
    private static final Buffer UNKOWN_REASON = Buffers.wrap((String)"Unknown");

    public SipRequestImpl(Buffer requestLine, Buffer headers, Buffer payload) {
        super(requestLine, headers, payload);
    }

    public SipRequestImpl(SipRequestLine requestLine, Buffer headers, Buffer payload) {
        super(requestLine, headers, payload);
    }

    @Override
    public Buffer getMethod() {
        return this.getRequestLine().getMethod();
    }

    @Override
    public URI getRequestUri() throws SipParseException {
        return this.getRequestLine().getRequestUri();
    }

    @Override
    public RouteHeader popRouteHeader() {
        SipHeader header = this.popHeader(RouteHeader.NAME);
        if (header instanceof RouteHeader) {
            return (RouteHeader)header;
        }
        if (header == null) {
            return null;
        }
        Buffer buffer = header.getValue();
        return RouteHeader.frame(buffer);
    }

    @Override
    public SipRequest toRequest() throws ClassCastException {
        return this;
    }

    @Override
    public SipRequest clone() {
        SipRequestLine requestLine = this.getRequestLine().clone();
        Buffer headers = this.cloneHeaders();
        Buffer payload = this.clonePayload();
        return new SipRequestImpl(requestLine, headers, payload);
    }

    @Override
    public SipResponse createResponse(int statusCode) throws SipParseException, ClassCastException {
        SipResponseLine initialLine = new SipResponseLine(statusCode, this.getDefaultResponseReason(statusCode));
        SipResponseImpl response = new SipResponseImpl(initialLine, null, null);
        CallIdHeader callID = this.getCallIDHeader();
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getToHeader();
        CSeqHeader cseq = this.getCSeqHeader();
        ViaHeader via = this.getViaHeader();
        SipHeader maxForwards = this.getHeader(MaxForwardsHeader.NAME);
        response.setHeader(from);
        response.setHeader(to);
        response.setHeader(callID);
        response.setHeader(cseq);
        response.setHeader(via);
        response.setHeader(maxForwards);
        return response;
    }

    private Buffer getDefaultResponseReason(int statusCode) {
        Buffer reason = DEFAULT_RESPONSE_REASON[statusCode];
        if (reason != null) {
            return reason.slice();
        }
        return UNKOWN_REASON.slice();
    }

    static {
        SipRequestImpl.DEFAULT_RESPONSE_REASON[100] = Buffers.wrap((String)"Trying");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[180] = Buffers.wrap((String)"Ringing");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[181] = Buffers.wrap((String)"Call is Being Forwarded");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[182] = Buffers.wrap((String)"Queued");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[199] = Buffers.wrap((String)"Early Dialog Terminated");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[200] = Buffers.wrap((String)"OK");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[202] = Buffers.wrap((String)"Accepted");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[204] = Buffers.wrap((String)"No Notification");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[300] = Buffers.wrap((String)"Multiple Choices");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[301] = Buffers.wrap((String)"Moved Permanently");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[302] = Buffers.wrap((String)"Moved Temporarily");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[305] = Buffers.wrap((String)"Use Proxy");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[380] = Buffers.wrap((String)"Alternative Service");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[400] = Buffers.wrap((String)"Bad Request");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[401] = Buffers.wrap((String)"Unauthorized");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[402] = Buffers.wrap((String)"Payment Required");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[403] = Buffers.wrap((String)"Forbidden");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[404] = Buffers.wrap((String)"Not Found");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[405] = Buffers.wrap((String)"Method Not Allowed");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[406] = Buffers.wrap((String)"Not Acceptable");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[407] = Buffers.wrap((String)"Proxy Authentication Required");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[408] = Buffers.wrap((String)"Request Timeout");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[409] = Buffers.wrap((String)"Conflict");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[410] = Buffers.wrap((String)"Gone");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[411] = Buffers.wrap((String)"Length Required");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[412] = Buffers.wrap((String)"Conditional Request Failed");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[413] = Buffers.wrap((String)"Request Entity Too Large");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[414] = Buffers.wrap((String)"Request-URI Too Long");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[415] = Buffers.wrap((String)"Unsupported Media Type");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[416] = Buffers.wrap((String)"Unsupported URI Scheme");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[417] = Buffers.wrap((String)"Unknown Resource-Priority");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[420] = Buffers.wrap((String)"Bad Extension");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[421] = Buffers.wrap((String)"Extension Required");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[422] = Buffers.wrap((String)"Session Interval Too Small");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[423] = Buffers.wrap((String)"Interval Too Brief");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[424] = Buffers.wrap((String)"Bad Location Information");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[428] = Buffers.wrap((String)"Use Identity Header");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[429] = Buffers.wrap((String)"Provide Referrer Identity");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[430] = Buffers.wrap((String)"Flow Failed");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[433] = Buffers.wrap((String)"Anonymity Disallowed");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[436] = Buffers.wrap((String)"Bad Identity-Info");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[437] = Buffers.wrap((String)"Unsupported Certificate");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[438] = Buffers.wrap((String)"Invalid Identity Header");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[439] = Buffers.wrap((String)"First Hop Lacks Outbound Support");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[470] = Buffers.wrap((String)"Consent Needed");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[480] = Buffers.wrap((String)"Temporarily Unavailable");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[481] = Buffers.wrap((String)"Call/Transaction Does Not Exist");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[482] = Buffers.wrap((String)"Loop Detected.");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[483] = Buffers.wrap((String)"Too Many Hops");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[484] = Buffers.wrap((String)"Address Incomplete");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[485] = Buffers.wrap((String)"Ambiguous");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[486] = Buffers.wrap((String)"Busy Here");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[487] = Buffers.wrap((String)"Request Terminated");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[488] = Buffers.wrap((String)"Not Acceptable Here");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[489] = Buffers.wrap((String)"Bad Event");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[491] = Buffers.wrap((String)"Request Pending");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[493] = Buffers.wrap((String)"Undecipherable");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[494] = Buffers.wrap((String)"Security Agreement Required");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[500] = Buffers.wrap((String)"Server Internal Error");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[501] = Buffers.wrap((String)"Not Implemented");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[502] = Buffers.wrap((String)"Bad Gateway");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[503] = Buffers.wrap((String)"Service Unavailable");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[504] = Buffers.wrap((String)"Server Time-out");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[505] = Buffers.wrap((String)"Version Not Supported");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[513] = Buffers.wrap((String)"Message Too Large");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[580] = Buffers.wrap((String)"Precondition Failure");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[600] = Buffers.wrap((String)"Busy Everywhere");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[603] = Buffers.wrap((String)"Decline");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[604] = Buffers.wrap((String)"Does Not Exist Anywhere");
        SipRequestImpl.DEFAULT_RESPONSE_REASON[606] = Buffers.wrap((String)"Not Acceptable");
    }
}

