/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipParser;
import io.pkts.packet.sip.impl.SipRequestLine;
import io.pkts.packet.sip.impl.SipResponseLine;
import io.pkts.sdp.SDPFactory;
import io.pkts.sdp.SdpException;
import io.pkts.sdp.SdpParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class SipMessageImpl
implements SipMessage {
    public static final Buffer FROM_HEADER = Buffers.wrap((byte[])"From".getBytes());
    public static final Buffer TO_HEADER = Buffers.wrap((byte[])"To".getBytes());
    public static final Buffer Call_ID_HEADER = Buffers.wrap((byte[])"Call-ID".getBytes());
    public static final Buffer CSEQ_HEADER = Buffers.wrap((byte[])"CSeq".getBytes());
    private final SDPFactory sdpFactory = SDPFactory.getInstance();
    private SipInitialLine initialLine;
    private final Buffer rawInitialLine;
    private final Buffer headers;
    private final Buffer payload;
    private final Map<Buffer, List<SipHeader>> parsedHeaders = new LinkedHashMap<Buffer, List<SipHeader>>(16, 0.75f);

    public SipMessageImpl(Buffer rawInitialBuffer, Buffer headers, Buffer payload) {
        this.rawInitialLine = rawInitialBuffer;
        this.headers = headers;
        this.payload = payload;
    }

    public SipMessageImpl(SipInitialLine initialLine, Buffer headers, Buffer payload) {
        this.initialLine = initialLine;
        this.rawInitialLine = null;
        this.headers = headers;
        this.payload = payload;
    }

    @Override
    public Buffer getInitialLine() {
        if (this.initialLine == null) {
            return this.rawInitialLine;
        }
        return this.initialLine.getBuffer();
    }

    @Override
    public final boolean isResponse() {
        return this.getInitialLineInternal().isResponseLine();
    }

    @Override
    public final boolean isRequest() {
        return this.getInitialLineInternal().isRequestLine();
    }

    private SipInitialLine getInitialLineInternal() {
        if (this.initialLine == null) {
            this.initialLine = SipInitialLine.parse(this.rawInitialLine);
        }
        return this.initialLine;
    }

    protected SipRequestLine getRequestLine() throws SipParseException, ClassCastException {
        return (SipRequestLine)this.getInitialLineInternal();
    }

    protected SipResponseLine getResponseLine() throws SipParseException, ClassCastException {
        return (SipResponseLine)this.getInitialLineInternal();
    }

    public SipHeader getSipHeader(Buffer name) {
        return this.getHeaderInternal(name, true);
    }

    private SipHeader getHeaderInternal(Buffer headerName, boolean frame) throws SipParseException {
        SipHeader h;
        List<SipHeader> headers = this.parsedHeaders.get(headerName);
        SipHeader sipHeader = h = headers == null || headers.isEmpty() ? null : headers.get(0);
        if (h != null) {
            SipHeader framed;
            if (frame && (framed = h.ensure()) != h) {
                headers.set(0, framed);
                return framed;
            }
            return h;
        }
        while (this.headers != null && this.headers.hasReadableBytes()) {
            List<SipHeader> nextHeaders = SipParser.nextHeaders(this.headers);
            if (nextHeaders == null || nextHeaders.isEmpty()) {
                return null;
            }
            Buffer currentHeaderName = nextHeaders.get(0).getName();
            headers = this.parsedHeaders.get(currentHeaderName);
            if (headers == null) {
                this.parsedHeaders.put(currentHeaderName, nextHeaders);
            } else {
                headers.addAll(nextHeaders);
            }
            if (!currentHeaderName.equals((Object)headerName)) continue;
            SipHeader header = nextHeaders.get(0);
            if (frame) {
                SipHeader framed = header.ensure();
                if (framed != header) {
                    nextHeaders.set(0, framed);
                }
                return framed;
            }
            return header;
        }
        return null;
    }

    private SipHeader ensureHeaderIsFramed(SipHeader header) {
        Function<SipHeader, ? extends SipHeader> function = SipParser.framers.get(header.getName());
        if (function != null) {
            return function.apply(header);
        }
        return header;
    }

    @Override
    public SipHeader getHeader(Buffer headerName) throws SipParseException {
        return this.getHeaderInternal(headerName, false);
    }

    @Override
    public SipHeader popHeader(Buffer headerName) throws SipParseException {
        SipHeader header = this.getHeader(headerName);
        if (header == null) {
            return null;
        }
        List<SipHeader> headers = this.parsedHeaders.get(headerName);
        headers.remove(0);
        if (headers.isEmpty()) {
            this.parsedHeaders.remove(headerName);
        }
        return header;
    }

    @Override
    public void addHeader(SipHeader header) {
        this.internalAddHeader(header, false);
    }

    private void frameAllHeaders() throws SipParseException {
        while (this.headers != null && this.headers.hasReadableBytes()) {
            List<SipHeader> nextHeaders = SipParser.nextHeaders(this.headers);
            if (nextHeaders == null || nextHeaders.isEmpty()) {
                return;
            }
            Buffer currentHeaderName = nextHeaders.get(0).getName();
            List<SipHeader> headers = this.parsedHeaders.get(currentHeaderName);
            if (headers == null) {
                this.parsedHeaders.put(currentHeaderName, nextHeaders);
                continue;
            }
            headers.addAll(nextHeaders);
        }
    }

    private void internalAddHeader(SipHeader header, boolean addFirst) {
        List<SipHeader> headers = this.parsedHeaders.get(header.getName());
        if (headers == null) {
            headers = new ArrayList<SipHeader>();
            this.parsedHeaders.put(header.getName(), headers);
        }
        if (addFirst) {
            headers.add(0, header);
        } else {
            headers.add(header);
        }
    }

    @Override
    public void addHeaderFirst(SipHeader header) throws SipParseException {
        this.internalAddHeader(header, true);
    }

    @Override
    public void setHeader(SipHeader header) throws SipParseException {
        this.frameAllHeaders();
        ArrayList<SipHeader> headers = new ArrayList<SipHeader>();
        headers.add(header);
        this.parsedHeaders.put(header.getName(), headers);
    }

    @Override
    public SipHeader getHeader(String headerName) throws SipParseException {
        return this.getHeader(Buffers.wrap((String)headerName));
    }

    @Override
    public FromHeader getFromHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(FromHeader.NAME, true);
        return (FromHeader)header;
    }

    @Override
    public ViaHeader getViaHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(ViaHeader.NAME, true);
        return (ViaHeader)header;
    }

    @Override
    public List<ViaHeader> getViaHeaders() throws SipParseException {
        this.frameAllHeaders();
        List<SipHeader> headers = this.parsedHeaders.get(ViaHeader.NAME);
        if (headers == null || headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ViaHeader> vias = new ArrayList<ViaHeader>(headers.size());
        for (int i = 0; i < headers.size(); ++i) {
            SipHeader header = headers.get(i);
            if (header instanceof ViaHeader) {
                vias.add((ViaHeader)header);
                continue;
            }
            Buffer buffer = header.getValue();
            ViaHeader via = ViaHeader.frame(buffer);
            headers.set(i, via);
            vias.add(via);
        }
        return vias;
    }

    @Override
    public List<RouteHeader> getRouteHeaders() throws SipParseException {
        this.frameAllHeaders();
        List<SipHeader> headers = this.parsedHeaders.get(RouteHeader.NAME);
        if (headers == null || headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RouteHeader> routes = new ArrayList<RouteHeader>(headers.size());
        for (int i = 0; i < headers.size(); ++i) {
            SipHeader header = headers.get(i);
            if (header instanceof RouteHeader) {
                routes.add((RouteHeader)header);
                continue;
            }
            Buffer buffer = header.getValue();
            RouteHeader route = RouteHeader.frame(buffer);
            headers.set(i, route);
            routes.add(route);
        }
        return routes;
    }

    @Override
    public RecordRouteHeader getRecordRouteHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(RecordRouteHeader.NAME, true);
        return (RecordRouteHeader)header;
    }

    @Override
    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipParseException {
        this.frameAllHeaders();
        List<SipHeader> headers = this.parsedHeaders.get(RecordRouteHeader.NAME);
        if (headers == null || headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RecordRouteHeader> recordRoutes = new ArrayList<RecordRouteHeader>(headers.size());
        for (int i = 0; i < headers.size(); ++i) {
            SipHeader header = headers.get(i);
            if (header instanceof RecordRouteHeader) {
                recordRoutes.add((RecordRouteHeader)header);
                continue;
            }
            Buffer buffer = header.getValue();
            RecordRouteHeader rr = RecordRouteHeader.frame(buffer);
            headers.set(i, rr);
            recordRoutes.add(rr);
        }
        return recordRoutes;
    }

    @Override
    public RouteHeader getRouteHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(RouteHeader.NAME, true);
        return (RouteHeader)header;
    }

    @Override
    public MaxForwardsHeader getMaxForwards() throws SipParseException {
        SipHeader header = this.getHeaderInternal(MaxForwardsHeader.NAME, true);
        return (MaxForwardsHeader)header;
    }

    @Override
    public ExpiresHeader getExpiresHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(ExpiresHeader.NAME, true);
        return (ExpiresHeader)header;
    }

    @Override
    public ContactHeader getContactHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(ContactHeader.NAME, true);
        return (ContactHeader)header;
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(ContentTypeHeader.NAME, true);
        return (ContentTypeHeader)header;
    }

    @Override
    public ToHeader getToHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(ToHeader.NAME, true);
        return (ToHeader)header;
    }

    @Override
    public CSeqHeader getCSeqHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(CSeqHeader.NAME, true);
        return (CSeqHeader)header;
    }

    @Override
    public CallIdHeader getCallIDHeader() throws SipParseException {
        SipHeader header = this.getHeaderInternal(CallIdHeader.NAME, true);
        if (header != null) {
            return (CallIdHeader)header;
        }
        return (CallIdHeader)this.getHeaderInternal(CallIdHeader.COMPACT_NAME, true);
    }

    @Override
    public abstract Buffer getMethod() throws SipParseException;

    @Override
    public void verify() {
    }

    @Override
    public boolean isInitial() throws SipParseException {
        ToHeader to = this.getToHeader();
        return to.getTag() == null;
    }

    @Override
    public boolean isInvite() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 73 && m.getByte(1) == 78 && m.getByte(2) == 86 && m.getByte(3) == 73 && m.getByte(4) == 84 && m.getByte(5) == 69;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isRegister() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 82 && m.getByte(1) == 69 && m.getByte(2) == 71 && m.getByte(3) == 73 && m.getByte(4) == 83 && m.getByte(5) == 84 && m.getByte(6) == 69 && m.getByte(7) == 82;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isBye() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 66 && m.getByte(1) == 89 && m.getByte(2) == 69;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isAck() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 65 && m.getByte(1) == 67 && m.getByte(2) == 75;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isCancel() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 67 && m.getByte(1) == 65 && m.getByte(2) == 78 && m.getByte(3) == 67 && m.getByte(4) == 69 && m.getByte(5) == 76;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isOptions() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 79 && m.getByte(1) == 80 && m.getByte(2) == 84 && m.getByte(3) == 73 && m.getByte(4) == 79 && m.getByte(5) == 78 && m.getByte(6) == 83;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isMessage() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 77 && m.getByte(1) == 69 && m.getByte(2) == 83 && m.getByte(3) == 83 && m.getByte(4) == 65 && m.getByte(5) == 71 && m.getByte(6) == 69;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    @Override
    public boolean isInfo() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 73 && m.getByte(1) == 78 && m.getByte(2) == 70 && m.getByte(3) == 79;
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse out the method due to underlying IOException", e);
        }
    }

    public String toString() {
        return this.toBuffer().toString();
    }

    @Override
    public final Object getContent() throws SipParseException {
        if (!this.hasContent()) {
            return null;
        }
        try {
            ContentTypeHeader contentType = this.getContentTypeHeader();
            if (contentType == null) {
                return null;
            }
            if (contentType.isSDP()) {
                try {
                    return this.sdpFactory.parse(this.payload);
                }
                catch (SdpParseException e) {
                    throw new SipParseException(e.getCharOffset(), e.getMessage(), (Exception)((Object)e));
                }
                catch (SdpException e) {
                    throw new SipParseException(0, "Unable to parse the content as an SDP", (Exception)((Object)e));
                }
            }
            return this.payload;
        }
        catch (SipParseException e) {
            throw new SipParseException(e.getErrorOffset(), "Unable to process the Content-Type header", e);
        }
    }

    @Override
    public final Buffer getRawContent() {
        if (!this.hasContent()) {
            return null;
        }
        return this.payload.slice();
    }

    @Override
    public final boolean hasContent() {
        return this.payload != null && this.payload.hasReadableBytes();
    }

    @Override
    public SipRequest toRequest() throws ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipRequest");
    }

    @Override
    public SipResponse toResponse() throws ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipResponse");
    }

    @Override
    public SipResponse createResponse(int responseCode) throws SipParseException, ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipRequest");
    }

    @Override
    public Buffer toBuffer() {
        Buffer buffer = Buffers.createBuffer((int)2048);
        this.getInitialLine().getBytes(buffer);
        buffer.write((byte)13);
        buffer.write((byte)10);
        this.transferHeaders(buffer);
        if (this.payload != null) {
            this.payload.getBytes(0, buffer);
        }
        return buffer;
    }

    protected Buffer cloneHeaders() {
        if (this.headers.getReaderIndex() == 0) {
            return this.headers.clone();
        }
        Buffer headerClone = Buffers.createBuffer((int)(this.headers.capacity() + 200));
        this.transferHeaders(headerClone);
        return headerClone;
    }

    protected Buffer clonePayload() {
        if (this.payload != null) {
            return this.payload.clone();
        }
        return null;
    }

    protected void transferHeaders(Buffer dst) {
        for (Map.Entry<Buffer, List<SipHeader>> headers : this.parsedHeaders.entrySet()) {
            for (SipHeader header : headers.getValue()) {
                header.getBytes(dst);
                dst.write((byte)13);
                dst.write((byte)10);
            }
        }
        if (this.headers != null) {
            this.headers.getBytes(dst);
        }
    }

    @Override
    public abstract SipMessage clone();
}

