/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public final class ViaHeaderImpl
implements ViaHeader,
SipHeader,
Parameters {
    private static final Buffer BRANCH = Buffers.wrap((String)"branch");
    private static final Buffer RECEIVED = Buffers.wrap((String)"received");
    private static final Buffer RPORT = Buffers.wrap((String)"rport");
    private static final Buffer TTL = Buffers.wrap((String)"ttl");
    private final Buffer original;
    private final Buffer transport;
    private final Buffer host;
    private final Buffer rawPort;
    private int port = -2;
    private final List<Buffer[]> params;
    private int indexOfBranch = -1;
    private int indexOfReceived = -1;
    private int indexOfRPort = -1;
    private final int indexOfTTL = -1;

    public ViaHeaderImpl(Buffer original, Buffer transport, Buffer host, Buffer port, List<Buffer[]> params) {
        this.original = original;
        this.transport = transport;
        this.host = host;
        this.rawPort = port;
        if (this.rawPort == null) {
            this.port = -1;
        }
        this.params = params;
    }

    public ViaHeaderImpl(Buffer transport, Buffer host, int port, Buffer branch) {
        assert (port >= -1);
        this.original = null;
        this.transport = transport;
        this.port = port;
        this.host = host;
        this.rawPort = null;
        this.params = new ArrayList<Buffer[]>();
        if (branch != null) {
            this.indexOfBranch = 0;
            this.params.add(new Buffer[]{BRANCH, branch});
        }
    }

    @Override
    public Buffer getParameter(Buffer name) throws SipParseException, IllegalArgumentException {
        int index = this.findParameter(name);
        if (index == -1) {
            return null;
        }
        return this.params.get(index)[1];
    }

    @Override
    public Buffer getParameter(String name) throws SipParseException, IllegalArgumentException {
        return this.getParameter(Buffers.wrap((String)name));
    }

    @Override
    public void setParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
        int index = this.findParameter(name);
        if (index == -1) {
            this.params.add(new Buffer[]{name, value});
        } else {
            this.params.get((int)index)[1] = value;
        }
    }

    @Override
    public void setParameter(Buffer name, Supplier<Buffer> value) throws SipParseException, IllegalArgumentException {
        PreConditions.assertNotNull(value);
        this.setParameter(name, value.get());
    }

    @Override
    public Buffer getName() {
        return ViaHeader.NAME;
    }

    @Override
    public Buffer getTransport() {
        return this.transport;
    }

    @Override
    public int getTTL() {
        return -1;
    }

    @Override
    public Buffer getValue() {
        Buffer buffer = Buffers.createBuffer((int)1024);
        this.transferValue(buffer);
        return buffer;
    }

    @Override
    public Buffer getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        if (this.port == -2) {
            this.port = Integer.parseInt(this.rawPort.toString());
        }
        return this.port;
    }

    @Override
    public Buffer getReceived() {
        if (this.indexOfReceived == -1) {
            this.indexOfReceived = this.findParameter(RECEIVED);
        }
        if (this.indexOfReceived == -1) {
            return null;
        }
        return this.params.get(this.indexOfReceived)[1];
    }

    @Override
    public void setReceived(Buffer received) {
        if (this.indexOfReceived == -1) {
            this.indexOfReceived = this.findParameter(RECEIVED);
        }
        if (this.indexOfReceived == -1) {
            this.indexOfReceived = this.params.size();
            this.params.add(new Buffer[]{RECEIVED, received});
        } else {
            this.params.get((int)this.indexOfReceived)[1] = received;
        }
    }

    @Override
    public boolean hasRPort() {
        if (this.indexOfRPort == -1) {
            this.indexOfRPort = this.findParameter(RPORT);
        }
        return this.indexOfRPort != -1;
    }

    @Override
    public int getRPort() {
        if (this.indexOfRPort == -1) {
            this.indexOfRPort = this.findParameter(RPORT);
        }
        if (this.indexOfRPort == -1) {
            return -1;
        }
        Buffer port = this.params.get(this.indexOfRPort)[1];
        if (port == null) {
            return -1;
        }
        try {
            return port.parseToInt();
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public void setRPort(int port) {
        if (this.indexOfRPort == -1) {
            this.indexOfRPort = this.findParameter(RPORT);
        }
        if (this.indexOfRPort == -1) {
            this.indexOfRPort = this.params.size();
            this.params.add(new Buffer[]{RPORT, Buffers.wrap((int)port)});
        } else {
            this.params.get((int)this.indexOfRPort)[1] = Buffers.wrap((int)port);
        }
    }

    @Override
    public Buffer getBranch() {
        if (this.indexOfBranch == -1) {
            this.indexOfBranch = this.findParameter(BRANCH);
        }
        if (this.indexOfBranch == -1) {
            return null;
        }
        return this.params.get(this.indexOfBranch)[1];
    }

    private int findParameter(Buffer param) {
        for (int i = 0; i < this.params.size(); ++i) {
            Buffer[] keyValue = this.params.get(i);
            if (!keyValue[0].equals((Object)param)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setBranch(Buffer branch) {
        if (this.indexOfBranch == -1) {
            this.indexOfBranch = this.findParameter(BRANCH);
        }
        if (this.indexOfBranch == -1) {
            this.indexOfBranch = this.params.size();
            this.params.add(new Buffer[]{BRANCH, branch});
        } else {
            this.params.get((int)this.indexOfBranch)[1] = branch;
        }
    }

    @Override
    public boolean isUDP() {
        return SipParser.isUDP(this.transport);
    }

    @Override
    public boolean isTCP() {
        return SipParser.isTCP(this.transport);
    }

    @Override
    public boolean isTLS() {
        return SipParser.isTLS(this.transport);
    }

    @Override
    public boolean isSCTP() {
        return SipParser.isSCTP(this.transport);
    }

    @Override
    public void verify() throws SipParseException {
        if (this.getBranch() == null) {
            throw new SipParseException(0, "Did not find the mandatory branch parameter. Via is illegal");
        }
    }

    public String toString() {
        Buffer buffer = Buffers.createBuffer((int)1024);
        this.getBytes(buffer);
        return buffer.toString();
    }

    @Override
    public void getBytes(Buffer dst) {
        NAME.getBytes(0, dst);
        dst.write((byte)58);
        dst.write((byte)32);
        this.transferValue(dst);
    }

    protected void transferValue(Buffer dst) {
        SipParser.SIP2_0_SLASH.getBytes(0, dst);
        this.transport.getBytes(0, dst);
        dst.write((byte)32);
        this.host.getBytes(0, dst);
        if (this.port == -2 && this.rawPort != null) {
            dst.write((byte)58);
            this.rawPort.getBytes(dst);
        } else if (this.port != -1) {
            dst.write((byte)58);
            dst.writeAsString(this.port);
        }
        for (Buffer[] param : this.params) {
            dst.write((byte)59);
            param[0].getBytes(0, dst);
            if (param[1] == null) continue;
            dst.write((byte)61);
            param[1].getBytes(0, dst);
        }
    }

    @Override
    public ViaHeader clone() {
        Buffer buffer = Buffers.createBuffer((int)1024);
        this.transferValue(buffer);
        try {
            return ViaHeader.frame(buffer);
        }
        catch (SipParseException e) {
            throw new RuntimeException("Unable to clone the Via-header", e);
        }
    }

    @Override
    public ViaHeader ensure() {
        return this;
    }
}

