/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.impl.SipParser;
import java.util.function.Function;

public class SipHeaderImpl
implements SipHeader {
    private final Buffer name;
    private final Buffer value;

    public SipHeaderImpl(Buffer name, Buffer value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public Buffer getName() {
        return this.name;
    }

    @Override
    public Buffer getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName().toString() + ": " + this.getValue();
    }

    @Override
    public void verify() throws SipParseException {
    }

    @Override
    public SipHeader ensure() {
        Function<SipHeader, ? extends SipHeader> framer = SipParser.framers.get(this.name);
        if (framer != null) {
            return framer.apply(this);
        }
        return this;
    }

    @Override
    public void getBytes(Buffer dst) {
        this.name.getBytes(0, dst);
        dst.write((byte)58);
        dst.write((byte)32);
        this.transferValue(dst);
    }

    protected void transferValue(Buffer dst) {
        Buffer value = this.getValue();
        value.getBytes(0, dst);
    }

    @Override
    public SipHeader clone() {
        Buffer buffer = Buffers.createBuffer((int)1024);
        this.transferValue(buffer);
        return new SipHeaderImpl(this.name.clone(), buffer);
    }
}

