/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.impl.SipHeaderImpl;
import java.util.UUID;

public final class CallIdHeaderImpl
extends SipHeaderImpl
implements CallIdHeader {
    public CallIdHeaderImpl() {
        super(CallIdHeader.NAME, CallIdHeaderImpl.generateCallId());
    }

    public CallIdHeaderImpl(Buffer value) {
        super(CallIdHeader.NAME, value);
    }

    public CallIdHeaderImpl(boolean compactForm, Buffer value) {
        super(compactForm ? CallIdHeader.COMPACT_NAME : CallIdHeader.NAME, value);
    }

    @Override
    public Buffer getCallId() {
        return this.getValue();
    }

    @Override
    public CallIdHeader clone() {
        try {
            return CallIdHeader.frame(this.getValue().clone());
        }
        catch (SipParseException e) {
            throw new RuntimeException("Unable to clone the CallId-header", e);
        }
    }

    private static final Buffer generateCallId() {
        return Buffers.wrap((String)UUID.randomUUID().toString());
    }

    public int hashCode() {
        Buffer value = this.getValue();
        int prime = 31;
        int result = 1;
        result = 31 * result + (value == null ? 0 : value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallIdHeaderImpl other = (CallIdHeaderImpl)obj;
        Buffer value = this.getValue();
        Buffer otherValue = other.getValue();
        return !(value == null ? otherValue != null : !value.equals((Object)otherValue));
    }

    @Override
    public CallIdHeader ensure() {
        return this;
    }
}

