/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.impl.SipHeaderImpl;

public final class CSeqHeaderImpl
extends SipHeaderImpl
implements CSeqHeader {
    private final long cseqNumber;
    private final Buffer method;

    public CSeqHeaderImpl(long cseqNumber, Buffer method, Buffer value) {
        super(CSeqHeader.NAME, value);
        this.cseqNumber = cseqNumber;
        this.method = method;
    }

    @Override
    public Buffer getMethod() {
        return this.method;
    }

    @Override
    public long getSeqNumber() {
        return this.cseqNumber;
    }

    @Override
    public Buffer getValue() {
        if (super.getValue() != null) {
            return super.getValue();
        }
        int size = Buffers.stringSizeOf((long)this.cseqNumber);
        Buffer value = Buffers.createBuffer((int)(size + 1 + this.method.getReadableBytes()));
        value.writeAsString(this.cseqNumber);
        value.write((byte)32);
        this.method.getBytes(value);
        return value;
    }

    @Override
    public CSeqHeader clone() {
        return new CSeqHeaderImpl(this.cseqNumber, this.method.clone(), this.getValue().clone());
    }

    @Override
    public CSeqHeader ensure() {
        return this;
    }
}

