/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.ParametersImpl;

public class AddressParametersHeaderImpl
extends ParametersImpl
implements AddressParametersHeader {
    public static final Buffer TAG = Buffers.wrap((String)"tag");
    private final Address address;

    public AddressParametersHeaderImpl(Buffer name, Address address, Buffer params) {
        super(name, params);
        this.address = address;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Buffer getValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.address.toString());
        Buffer superValue = super.getValue();
        if (superValue != null) {
            sb.append(superValue.toString());
        }
        return Buffers.wrap((String)sb.toString());
    }

    @Override
    protected void transferValue(Buffer dst) {
        this.address.getBytes(dst);
        super.transferValue(dst);
    }

    @Override
    public AddressParametersHeader ensure() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressParametersHeaderImpl other = (AddressParametersHeaderImpl)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }
}

