/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.ViaHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;

public interface ViaHeader
extends Parameters,
SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Via");

    public Buffer getTransport();

    public Buffer getHost();

    public int getPort();

    public Buffer getReceived();

    public void setReceived(Buffer var1);

    public boolean hasRPort();

    public int getRPort();

    public void setRPort(int var1);

    public Buffer getBranch();

    public void setBranch(Buffer var1);

    public int getTTL();

    public boolean isUDP();

    public boolean isTCP();

    public boolean isTLS();

    public boolean isSCTP();

    @Override
    public ViaHeader clone();

    public static ViaHeader frame(Buffer buffer) throws SipParseException {
        try {
            Buffer original = buffer.slice();
            Object[] result = SipParser.consumeVia(buffer);
            Buffer transport = (Buffer)result[0];
            Buffer host = (Buffer)result[1];
            Buffer port = result[2] == null ? null : (Buffer)result[2];
            List params = (List)result[3];
            return new ViaHeaderImpl(original, transport, host, port, params);
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to frame the Via header due to IOException", e);
        }
    }

    public static Buffer generateBranch() {
        return Buffers.wrap((String)("z9hG4bK-" + UUID.randomUUID().toString()));
    }

    public static ViaHeaderBuilder with() {
        return new ViaHeaderBuilder();
    }

    public static class ViaHeaderBuilder {
        private static final Buffer udp = Buffers.wrap((String)"UDP");
        private static final Buffer tcp = Buffers.wrap((String)"TCP");
        private static final Buffer tls = Buffers.wrap((String)"TLS");
        private static final Buffer sctp = Buffers.wrap((String)"SCTP");
        private static final Buffer ws = Buffers.wrap((String)"WS");
        private int port = -1;
        private Buffer host;
        private Buffer branch;
        private Buffer transport;

        public ViaHeaderBuilder port(int port) {
            PreConditions.assertArgument(port > 0, "Port must be greater than zer");
            this.port = port;
            return this;
        }

        public ViaHeaderBuilder transport(Buffer transport) throws SipParseException {
            PreConditions.assertNotNull(transport);
            if (SipParser.isUDP(transport) || SipParser.isTCP(transport) || SipParser.isTLS(transport) || SipParser.isWS(transport) || SipParser.isSCTP(transport)) {
                this.transport = transport.clone();
                return this;
            }
            throw new SipParseException(0, "Illegal transport");
        }

        public ViaHeaderBuilder transport(String transport) throws SipParseException {
            return this.transport(Buffers.wrap((String)PreConditions.assertNotEmpty(transport, "Transport cannot be null or the empty string")));
        }

        public ViaHeaderBuilder host(Buffer host) {
            this.host = PreConditions.assertNotEmpty(host, "Host cannot be empty or null");
            return this;
        }

        public ViaHeaderBuilder host(String host) {
            PreConditions.assertNotEmpty(host, "Host cannot be empty or null");
            this.host = Buffers.wrap((String)host);
            return this;
        }

        public ViaHeaderBuilder branch(Buffer branch) {
            this.branch = PreConditions.assertNotEmpty(branch, "Branch cannot be empty or null.");
            return this;
        }

        public ViaHeaderBuilder branch(String branch) {
            PreConditions.assertNotEmpty(branch, "Branch cannot be empty or null.");
            this.branch = Buffers.wrap((String)branch);
            return this;
        }

        public ViaHeaderBuilder branch(Supplier<Buffer> branch) {
            PreConditions.assertNotNull(branch);
            this.branch = branch.get();
            return this;
        }

        public ViaHeaderBuilder transportUDP() {
            this.transport = udp.clone();
            return this;
        }

        public ViaHeaderBuilder transportSCTP() {
            this.transport = sctp.clone();
            return this;
        }

        public ViaHeaderBuilder transportTCP() {
            this.transport = tcp.clone();
            return this;
        }

        public ViaHeaderBuilder transportTLS() {
            this.transport = tls.clone();
            return this;
        }

        public ViaHeaderBuilder transportWS() {
            this.transport = ws.clone();
            return this;
        }

        public ViaHeader build() throws SipParseException {
            if (this.host == null) {
                throw new SipParseException("Missing host, cannot create ViaHeader");
            }
            return new ViaHeaderImpl(this.transport, this.host, this.port, this.branch);
        }
    }
}

