/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.ToHeaderImpl;
import java.util.Random;

public interface ToHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"To");

    public Buffer getTag() throws SipParseException;

    @Override
    public ToHeader clone();

    public static ToHeader frame(Buffer buffer) throws SipParseException {
        Object[] result = AddressParametersHeader.frame(buffer);
        return new ToHeaderImpl((Address)result[0], (Buffer)result[1]);
    }

    public static Buffer generateTag() {
        return Buffers.wrap((String)Integer.toHexString(new Random().nextInt()));
    }

    public static Builder with() {
        return new Builder();
    }

    public static Builder with(Address address) throws SipParseException {
        Builder builder = new Builder();
        builder.address(address);
        return builder;
    }

    public static class Builder
    extends AddressParametersHeader.Builder<ToHeader> {
        private Builder() {
            super(NAME);
        }

        @Override
        public ToHeader internalBuild(Address address, Buffer params) throws SipParseException {
            return new ToHeaderImpl(address, params);
        }
    }
}

