/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.impl.SipParser;

public interface MediaTypeHeader
extends SipHeader {
    public Buffer getContentType();

    public Buffer getContentSubType();

    public boolean isSDP();

    public static Buffer[] frame(Buffer buffer) throws SipParseException {
        if (buffer == null) {
            throw new SipParseException(0, "Cannot parse a null-buffer. Cmon!");
        }
        Buffer mType = SipParser.consumeMType(buffer);
        if (mType == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected m-type but got nothing");
        }
        SipParser.expectSLASH(buffer);
        Buffer subType = SipParser.consumeMSubtype(buffer);
        if (subType == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected m-subtype but got nothing");
        }
        return new Buffer[]{mType, subType};
    }
}

