/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.MaxForwardsHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import java.io.IOException;

public interface MaxForwardsHeader
extends SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Max-Forwards");

    public int getMaxForwards();

    public void setMaxForwards(int var1);

    public void decrement();

    public static MaxForwardsHeader frame(Buffer buffer) throws SipParseException {
        try {
            int value = buffer.parseToInt();
            return new MaxForwardsHeaderImpl(value);
        }
        catch (NumberFormatException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Max-Forwards header. Value is not an integer");
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Max-Forwards header. Got an IOException", e);
        }
    }

    @Override
    public MaxForwardsHeader clone();

    public static MaxForwardsHeader create(int max) {
        PreConditions.assertArgument(max >= 0, "The value must be greater or equal to zero");
        return new MaxForwardsHeaderImpl(max);
    }

    public static MaxForwardsHeader create() {
        return new MaxForwardsHeaderImpl(70);
    }
}

