/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.FromHeaderImpl;
import java.util.Random;

public interface FromHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"From");

    public Buffer getTag() throws SipParseException;

    @Override
    public FromHeader clone();

    public static FromHeader frame(Buffer buffer) throws SipParseException {
        Object[] result = AddressParametersHeader.frame(buffer);
        return new FromHeaderImpl((Address)result[0], (Buffer)result[1]);
    }

    public static Buffer generateTag() {
        return Buffers.wrap((String)Integer.toHexString(new Random().nextInt()));
    }

    public static Builder with() {
        return new Builder();
    }

    public static Builder with(Address address) throws SipParseException {
        Builder builder = new Builder();
        builder.address(address);
        return builder;
    }

    public static class Builder
    extends AddressParametersHeader.Builder<FromHeader> {
        private Builder() {
            super(NAME);
        }

        @Override
        public FromHeader internalBuild(Address address, Buffer params) throws SipParseException {
            return new FromHeaderImpl(address, params);
        }
    }
}

