/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.ContactHeaderImpl;

public interface ContactHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Contact");

    @Override
    public ContactHeader clone();

    public static Builder with() {
        return new Builder();
    }

    public static Builder with(Address address) throws SipParseException {
        Builder builder = new Builder();
        builder.address(address);
        return builder;
    }

    public static Builder with(SipURI uri) throws SipParseException {
        Builder builder = new Builder();
        Address address = Address.with(uri.clone()).build();
        builder.address(address);
        return builder;
    }

    public static ContactHeader frame(Buffer buffer) throws SipParseException {
        Object[] result = AddressParametersHeader.frame(buffer);
        return new ContactHeaderImpl((Address)result[0], (Buffer)result[1]);
    }

    public static class Builder
    extends AddressParametersHeader.Builder<ContactHeader> {
        private Builder() {
            super(NAME);
        }

        @Override
        public ContactHeader internalBuild(Address address, Buffer params) throws SipParseException {
            return new ContactHeaderImpl(address, params);
        }
    }
}

