/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.CSeqHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public interface CSeqHeader
extends SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"CSeq");

    public Buffer getMethod();

    public long getSeqNumber();

    @Override
    public CSeqHeader clone();

    public static CSeqHeader frame(Buffer value) throws SipParseException {
        try {
            Buffer valueCopy = value.slice();
            Buffer cseq = SipParser.expectDigit(value);
            long number = Long.parseLong(cseq.toString());
            SipParser.consumeWS(value);
            Buffer method = value.readLine();
            return new CSeqHeaderImpl(number, method, valueCopy);
        }
        catch (IOException e) {
            throw new SipParseException(value.getReaderIndex(), "Could not read from the underlying stream while parsing method");
        }
    }

    public static CSeqHeaderBuilder with() {
        return new CSeqHeaderBuilder();
    }

    public static class CSeqHeaderBuilder {
        private long cseq;
        private Buffer method;

        private CSeqHeaderBuilder() {
        }

        public CSeqHeaderBuilder cseq(long cseq) throws SipParseException {
            PreConditions.assertArgument(cseq >= 0L, "Sequence number must be greater or equal to zer");
            this.cseq = cseq;
            return this;
        }

        public CSeqHeaderBuilder method(Buffer method) throws SipParseException {
            this.method = PreConditions.assertNotEmpty(method, "Method cannot be null or empty");
            return this;
        }

        public CSeqHeaderBuilder method(String method) throws SipParseException {
            this.method = Buffers.wrap((String)PreConditions.assertNotEmpty(method, "Method cannot be null or empty"));
            return this;
        }

        public CSeqHeader build() {
            PreConditions.assertNotEmpty(this.method, "Method cannot be null or empty");
            return new CSeqHeaderImpl(this.cseq, this.method, null);
        }
    }
}

