/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.impl.AddressImpl;
import io.pkts.packet.sip.header.HeaderAddress;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.AddressParametersHeaderImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public interface AddressParametersHeader
extends SipHeader,
HeaderAddress,
Parameters {
    public static Object[] frame(Buffer buffer) throws SipParseException {
        try {
            Address address = AddressImpl.parse(buffer);
            Buffer params = null;
            if (buffer.hasReadableBytes()) {
                params = buffer.slice();
            }
            return new Object[]{address, params};
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to process the value due to a IndexOutOfBoundsException", e);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to process the To-header to due an IOException");
        }
    }

    public static <T> Builder<AddressParametersHeader> with(Buffer headerName) throws SipParseException {
        PreConditions.assertNotEmpty(headerName, "The name of the header cannot be null or the empty buffer");
        return new Builder<AddressParametersHeader>(headerName);
    }

    public static class Builder<T extends AddressParametersHeader> {
        private final Buffer name;
        private SipURI.Builder uriBuilder;
        private Address address;
        private final ParametersSupport paramSupport = new ParametersSupport(null);

        protected Builder(Buffer name) {
            this.name = name;
        }

        public final Builder<T> port(int port) {
            this.ensureBuilder().port(port);
            return this;
        }

        public final Builder<T> user(Buffer user) {
            this.ensureBuilder().user(user);
            return this;
        }

        public final Builder<T> user(String user) {
            this.ensureBuilder().user(user);
            return this;
        }

        public final Builder<T> host(Buffer host) {
            this.ensureBuilder().host(host);
            return this;
        }

        public final Builder<T> host(String host) {
            this.ensureBuilder().host(host);
            return this;
        }

        public Builder<T> parameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder<T> parameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder<T> uriParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.ensureBuilder().parameter(name, value);
            return this;
        }

        public Builder<T> uriParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.ensureBuilder().parameter(name, value);
            return this;
        }

        public Builder<T> transportTCP() throws SipParseException {
            this.ensureBuilder().parameter(SipParser.TRANSPORT, SipParser.TCP);
            return this;
        }

        public Builder<T> transportUDP() throws SipParseException {
            this.ensureBuilder().parameter(SipParser.TRANSPORT, SipParser.UDP);
            return this;
        }

        public Builder<T> transportTLS() throws SipParseException {
            this.ensureBuilder().parameter(SipParser.TRANSPORT, SipParser.TLS);
            return this;
        }

        public Builder<T> transportSCTP() throws SipParseException {
            this.ensureBuilder().parameter(SipParser.TRANSPORT, SipParser.SCTP);
            return this;
        }

        public Builder<T> transportWS() throws SipParseException {
            this.ensureBuilder().parameter(SipParser.TRANSPORT, SipParser.WS);
            return this;
        }

        public final Builder<T> address(Address address) {
            this.address = PreConditions.assertNotNull(address, "Address cannot be null");
            return this;
        }

        public final T build() throws SipParseException {
            if (this.uriBuilder != null && this.address != null) {
                throw new SipParseException("You specified both an address as well as parts of a SipURI. Not sure which to choose");
            }
            if (this.uriBuilder == null && this.address == null) {
                throw new SipParseException("You must sepcify either the host or a full address.");
            }
            Address addressToUse = this.address;
            if (this.uriBuilder != null) {
                SipURI uri = this.uriBuilder.build();
                addressToUse = Address.with(uri).build();
            }
            return this.internalBuild(addressToUse, this.paramSupport.toBuffer());
        }

        protected T internalBuild(Address address, Buffer params) {
            return (T)new AddressParametersHeaderImpl(this.name, address, params);
        }

        private SipURI.Builder ensureBuilder() {
            if (this.uriBuilder == null) {
                this.uriBuilder = SipURI.with();
            }
            return this.uriBuilder;
        }
    }
}

