/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.impl.URIImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class SipURIImpl
extends URIImpl
implements SipURI {
    private Buffer buffer;
    private final Buffer userInfo;
    private final Buffer host;
    private Buffer port;
    private final ParametersSupport paramsSupport;
    private final boolean isSecure;
    private boolean isDirty = false;

    public SipURIImpl(boolean isSips, Buffer userInfo, Buffer host, Buffer port, Buffer paramsHeaders, Buffer original) {
        super(isSips ? SipParser.SCHEME_SIPS : SipParser.SCHEME_SIP);
        this.isSecure = isSips;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.paramsSupport = new ParametersSupport(paramsHeaders);
        if (original == null) {
            this.isDirty = true;
        }
        this.buffer = original;
    }

    @Override
    public boolean isSipURI() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public void getBytes(Buffer dst) {
        if (!this.isDirty) {
            this.buffer.getBytes(dst);
        } else {
            if (this.isSecure) {
                SipParser.SCHEME_SIPS_COLON.getBytes(0, dst);
            } else {
                SipParser.SCHEME_SIP_COLON.getBytes(0, dst);
            }
            if (this.userInfo != null) {
                this.userInfo.getBytes(0, dst);
                dst.write((byte)64);
            }
            this.host.getBytes(0, dst);
            if (this.port != null) {
                dst.write((byte)58);
                this.port.getBytes(0, dst);
            }
            this.paramsSupport.transferValue(dst);
        }
    }

    @Override
    public SipURI clone() {
        try {
            if (!this.isDirty) {
                return SipURI.frame(this.buffer.clone());
            }
            return SipURI.frame(this.toBuffer());
        }
        catch (SipParseException | IOException | IndexOutOfBoundsException e) {
            throw new RuntimeException("Unable to clone the SipURI due to exception ", e);
        }
    }

    @Override
    public Buffer toBuffer() {
        if (!this.isDirty) {
            return this.buffer;
        }
        Buffer buffer = Buffers.createBuffer((int)1024);
        this.getBytes(buffer);
        this.isDirty = false;
        this.buffer = buffer.slice();
        return buffer;
    }

    @Override
    public Buffer getUser() {
        if (this.userInfo != null) {
            return this.userInfo.slice();
        }
        return Buffers.EMPTY_BUFFER;
    }

    @Override
    public Buffer getHost() {
        return this.host.slice();
    }

    @Override
    public int getPort() {
        if (this.port == null) {
            return -1;
        }
        try {
            return this.port.parseToInt();
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("The port could not be parsed as an integer. This should not be possible. The port was " + this.port);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while extracting out the port. This should not be possible.");
        }
    }

    @Override
    public void setPort(int port) {
        this.isDirty = true;
        this.port = port < 0 ? null : Buffers.wrap((int)port);
    }

    @Override
    public Buffer getTransportParam() throws SipParseException {
        return this.getParameter(SipParser.TRANSPORT);
    }

    @Override
    public Buffer getUserParam() throws SipParseException {
        return this.getParameter(SipParser.USER);
    }

    @Override
    public int getTTLParam() throws SipParseException {
        Buffer buffer = this.getParameter(SipParser.TTL);
        if (buffer == null || buffer.isEmpty()) {
            return -1;
        }
        try {
            return buffer.parseToInt();
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to parse buffer to an int", e);
        }
    }

    @Override
    public Buffer getMAddrParam() throws SipParseException {
        return this.getParameter(SipParser.MADDR);
    }

    @Override
    public Buffer getMethodParam() throws SipParseException {
        return this.getParameter(SipParser.METHOD);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        try {
            Set<Map.Entry<Buffer, Buffer>> entries;
            SipURIImpl o = (SipURIImpl)other;
            if (this.isSecure ^ o.isSecure()) {
                return false;
            }
            if (!this.getUser().equals((Object)o.getUser())) {
                return false;
            }
            if (!this.getHost().equalsIgnoreCase((Object)o.getHost())) {
                return false;
            }
            if (this.getPort() != o.getPort()) {
                return false;
            }
            if (this.getTransportParam() == null ^ o.getTransportParam() == null) {
                return false;
            }
            if (this.getUserParam() == null ^ o.getUserParam() == null) {
                return false;
            }
            if (this.getTTLParam() != o.getTTLParam()) {
                return false;
            }
            if (this.getMethodParam() == null ^ o.getMethodParam() == null) {
                return false;
            }
            if (this.getMAddrParam() == null ^ o.getMAddrParam() == null) {
                return false;
            }
            if (this.paramsSupport != null && o.paramsSupport != null && (entries = this.paramsSupport.getAllParameters()) != null) {
                for (Map.Entry<Buffer, Buffer> entry : entries) {
                    Buffer key = entry.getKey();
                    Buffer value = entry.getValue();
                    Buffer bValue = o.getParameter(key);
                    if (!o.paramsSupport.hasParameter(key)) continue;
                    if (value == null ^ bValue == null) {
                        return false;
                    }
                    if (value.equalsIgnoreCase((Object)bValue)) continue;
                    return false;
                }
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getPort();
        result = 31 * result + this.getUser().hashCode();
        result = 31 * result + this.getHost().toString().toLowerCase().hashCode();
        return result;
    }

    public String toString() {
        return this.toBuffer().toString();
    }

    @Override
    public Buffer getParameter(Buffer name) throws SipParseException, IllegalArgumentException {
        return this.paramsSupport.getParameter(name);
    }

    @Override
    public Buffer getParameter(String name) throws SipParseException, IllegalArgumentException {
        return this.paramsSupport.getParameter(name);
    }

    @Override
    public void setParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
        this.isDirty = true;
        this.paramsSupport.setParameter(name, value);
    }

    @Override
    public void setParameter(String name, String value) throws SipParseException, IllegalArgumentException {
        this.isDirty = true;
        this.paramsSupport.setParameter(name, value);
    }

    @Override
    public void setParameter(Buffer name, int value) throws SipParseException, IllegalArgumentException {
        this.setParameter(name, Buffers.wrap((int)value));
    }

    @Override
    public void setParameter(String name, int value) throws SipParseException, IllegalArgumentException {
        this.setParameter(Buffers.wrap((String)name), Buffers.wrap((int)value));
    }
}

