/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.ByteNotFoundException;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public final class AddressImpl
implements Address {
    private final Buffer displayName;
    private final Buffer uriBuffer;
    private URI uri;
    private final boolean enclosedDisplayName;
    private final boolean angleBrackets;

    private AddressImpl(Buffer displayName, Buffer uri, boolean enclosedDisplayName, boolean angleBrackets) {
        this.displayName = PreConditions.ifNull(displayName, Buffers.EMPTY_BUFFER);
        this.uriBuffer = uri;
        this.enclosedDisplayName = enclosedDisplayName;
        this.angleBrackets = angleBrackets;
    }

    public AddressImpl(Buffer displayName, URI uri) {
        this.displayName = PreConditions.ifNull(displayName, Buffers.EMPTY_BUFFER);
        this.uri = uri;
        this.uriBuffer = null;
        this.enclosedDisplayName = true;
        this.angleBrackets = true;
    }

    @Override
    public Buffer getDisplayName() {
        return this.displayName;
    }

    @Override
    public URI getURI() throws SipParseException {
        if (this.uri == null) {
            try {
                this.uri = URI.frame(this.uriBuffer);
            }
            catch (IndexOutOfBoundsException e) {
                throw new SipParseException(this.uriBuffer.getReaderIndex(), "Unable to process the value due to a IndexOutOfBoundsException", e);
            }
            catch (IOException e) {
                throw new SipParseException(this.uriBuffer.getReaderIndex(), "Could not read from the underlying stream while parsing the value");
            }
        }
        return this.uri;
    }

    public static final Address parse(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        SipParser.consumeWS(buffer);
        boolean doubleQuote = false;
        if (buffer.peekByte() == 34) {
            doubleQuote = true;
        }
        Buffer displayName = SipParser.consumeDisplayName(buffer);
        boolean leftAngleBracket = true;
        if (doubleQuote && displayName.isEmpty()) {
            SipParser.consumeWS(buffer);
        }
        if (displayName.isEmpty() && buffer.peekByte() == 60) {
            buffer.readByte();
        } else if (!displayName.isEmpty()) {
            SipParser.consumeWS(buffer);
            SipParser.expect(buffer, (byte)60);
        } else {
            leftAngleBracket = false;
        }
        Buffer addrSpec = null;
        if (!leftAngleBracket) {
            try {
                int index = buffer.indexOf(1024, new byte[]{59, 63, 13, 10});
                if (index >= 0) {
                    Buffer temp = buffer.readBytes(index - buffer.getReaderIndex());
                    addrSpec = SipParser.consumeAddressSpec(temp);
                }
                addrSpec = SipParser.consumeAddressSpec(buffer);
            }
            catch (ByteNotFoundException e) {
                throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the uri (addr-spec) portion of the address");
            }
        } else {
            addrSpec = SipParser.consumeAddressSpec(buffer);
        }
        if (addrSpec == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to find the name-addr portion");
        }
        if (displayName.isEmpty() && buffer.hasReadableBytes() && buffer.peekByte() == 62) {
            buffer.readByte();
        } else if (!displayName.isEmpty()) {
            SipParser.expect(buffer, (byte)62);
        }
        return new AddressImpl(displayName, addrSpec, doubleQuote, leftAngleBracket);
    }

    @Override
    public Buffer toBuffer() {
        Buffer buffer = Buffers.createBuffer((int)1024);
        this.getBytes(buffer);
        return buffer;
    }

    public String toString() {
        return this.toBuffer().toString();
    }

    @Override
    public void getBytes(Buffer dst) {
        if (!this.displayName.isEmpty()) {
            if (this.enclosedDisplayName) {
                dst.write((byte)34);
                this.displayName.getBytes(0, dst);
                dst.write((byte)34);
            } else {
                this.displayName.getBytes(0, dst);
            }
            dst.write((byte)32);
        }
        if (this.angleBrackets) {
            dst.write((byte)60);
            if (this.uri == null) {
                this.uriBuffer.getBytes(0, dst);
            } else {
                this.uri.getBytes(dst);
            }
            dst.write((byte)62);
        } else if (this.uri == null) {
            this.uriBuffer.getBytes(0, dst);
        } else {
            this.uri.getBytes(dst);
        }
    }
}

