/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.address.impl.SipURIImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public interface SipURI
extends URI {
    public Buffer getUser();

    public Buffer getHost();

    public int getPort();

    public void setPort(int var1);

    public boolean isSecure();

    public Buffer getTransportParam() throws SipParseException;

    public Buffer getUserParam() throws SipParseException;

    public int getTTLParam() throws SipParseException;

    public Buffer getMAddrParam() throws SipParseException;

    public Buffer getMethodParam() throws SipParseException;

    public Buffer getParameter(Buffer var1) throws SipParseException, IllegalArgumentException;

    public Buffer getParameter(String var1) throws SipParseException, IllegalArgumentException;

    public void setParameter(Buffer var1, Buffer var2) throws SipParseException, IllegalArgumentException;

    public void setParameter(String var1, String var2) throws SipParseException, IllegalArgumentException;

    public void setParameter(Buffer var1, int var2) throws SipParseException, IllegalArgumentException;

    public void setParameter(String var1, int var2) throws SipParseException, IllegalArgumentException;

    public boolean equals(Object var1);

    public Buffer toBuffer();

    @Override
    public SipURI clone();

    public static SipURI frame(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        Buffer original = buffer.slice();
        boolean isSips = SipParser.isSips(buffer);
        Buffer[] userHost = SipParser.consumeUserInfoHostPort(buffer);
        Buffer hostPort = userHost[1];
        Buffer host = null;
        Buffer port = null;
        while (hostPort.hasReadableBytes() && host == null) {
            byte b = hostPort.readByte();
            if (b != 58) continue;
            int index = hostPort.getReaderIndex();
            host = hostPort.slice(0, index - 1);
            port = hostPort.slice();
        }
        if (host == null) {
            hostPort.setReaderIndex(0);
            host = hostPort;
        }
        if (port != null) {
            try {
                port.parseToInt();
            }
            catch (NumberFormatException e) {
                throw new SipParseException(0, "The SipURI had a port but it was not an integer: \"" + port.toString() + "\"");
            }
        }
        return new SipURIImpl(isSips, userHost[0], host, port, buffer, original);
    }

    public static Builder with() {
        return new Builder();
    }

    public static Builder with(SipURI uri) {
        Builder b = new Builder();
        b.user(uri.getUser());
        b.host(uri.getHost());
        b.port(uri.getPort());
        b.secure(uri.isSecure());
        Buffer transport = uri.getTransportParam();
        if (transport != null && !transport.isEmpty()) {
            b.parameter(SipParser.TRANSPORT, transport);
        }
        return b;
    }

    public static class Builder {
        private Buffer user;
        private Buffer host;
        private int port = -1;
        private boolean isSecure;
        private final ParametersSupport paramSupport = new ParametersSupport(null);

        private Builder() {
        }

        public Builder user(Buffer user) {
            this.user = user != null ? user.slice() : null;
            return this;
        }

        public Builder user(String user) {
            if (PreConditions.checkIfNotEmpty(user)) {
                this.user = Buffers.wrap((String)user);
            }
            return this;
        }

        public Builder host(Buffer host) throws SipParseException {
            PreConditions.assertNotNull(host, "Host cannot be null");
            this.host = host.slice();
            return this;
        }

        public Builder host(String host) throws SipParseException {
            PreConditions.assertNotEmpty(host, "Host cannot be null or the empty string");
            this.host = Buffers.wrap((String)host);
            return this;
        }

        public Builder transport(Buffer transport) throws SipParseException {
            PreConditions.assertNotEmpty(transport, "Transport cannot be null or empty");
            this.paramSupport.setParameter(SipParser.TRANSPORT, transport);
            return this;
        }

        public Builder transport(String transport) throws SipParseException {
            PreConditions.assertNotEmpty(transport, "Transport cannot be null or empty");
            this.paramSupport.setParameter(SipParser.TRANSPORT, Buffers.wrap((String)transport));
            return this;
        }

        public Builder parameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder parameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder secure() {
            this.isSecure = true;
            return this;
        }

        public Builder secure(boolean secure) {
            this.isSecure = secure;
            return this;
        }

        public Builder port(int port) throws SipParseException {
            PreConditions.assertArgument(port > 0 || port == -1, "Port must be greater than zero or negative one (use default)");
            this.port = port;
            return this;
        }

        public Builder useUDP() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.UDP);
            return this;
        }

        public Builder useTCP() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.TCP);
            return this;
        }

        public Builder useTLS() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.TLS);
            return this;
        }

        public Builder useSCTP() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.SCTP);
            return this;
        }

        public Builder useWS() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.WS);
            return this;
        }

        public SipURI build() throws SipParseException {
            PreConditions.assertNotEmpty(this.host, "Host cannot be empty");
            Buffer port = this.convertPort();
            return new SipURIImpl(this.isSecure, this.user, this.host, port, this.paramSupport.toBuffer(), null);
        }

        private Buffer convertPort() {
            if (this.port == -1) {
                return null;
            }
            return Buffers.wrap((int)this.port);
        }
    }
}

