/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.address.impl.AddressImpl;
import io.pkts.packet.sip.impl.PreConditions;

public interface Address {
    public Buffer getDisplayName();

    public URI getURI() throws SipParseException;

    public Buffer toBuffer();

    public void getBytes(Buffer var1);

    public static AddressBuilder with() {
        return new AddressBuilder();
    }

    public static AddressBuilder with(URI uri) {
        return new AddressBuilder(PreConditions.assertNotNull(uri, "URI cannot be null"));
    }

    public static class AddressBuilder {
        private URI uri;
        private Buffer displayName;
        private Buffer user;
        private Buffer host;
        private int port = -1;

        private AddressBuilder() {
        }

        private AddressBuilder(URI uri) {
            this.uri = uri;
        }

        public AddressBuilder user(Buffer user) {
            this.user = user;
            return this;
        }

        public AddressBuilder port(int port) {
            PreConditions.assertArgument(port > 0 || port == -1, "Port must be greater than zero or negative one (use default)");
            this.port = port;
            return this;
        }

        public AddressBuilder host(Buffer host) {
            this.host = PreConditions.assertNotEmpty(host, "host cannot be empty or null");
            return this;
        }

        public AddressBuilder displayName(Buffer displayName) {
            this.displayName = PreConditions.ifNull(displayName, Buffers.EMPTY_BUFFER);
            return this;
        }

        public AddressBuilder displayName(String displayName) {
            this.displayName = Buffers.wrap((String)PreConditions.ifNull(displayName, ""));
            return this;
        }

        public AddressBuilder uri(URI uri) {
            this.uri = PreConditions.assertNotNull(uri, "URI cannot be null");
            return this;
        }

        public Address build() throws SipParseException {
            if (this.host != null && this.uri != null) {
                throw new SipParseException("Both host and URI was specified. Not sure which to pick");
            }
            if (this.host == null && this.uri == null) {
                throw new SipParseException("You must specify either a full address or a host");
            }
            URI uriToUse = this.uri;
            if (this.host != null) {
                uriToUse = SipURI.with().user(this.user).host(this.host).port(this.port).build();
            }
            return new AddressImpl(this.displayName, uriToUse);
        }
    }
}

