/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipRequestImpl;
import io.pkts.packet.sip.impl.SipRequestLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public interface SipRequest
extends SipMessage {
    public URI getRequestUri() throws SipParseException;

    public RouteHeader popRouteHeader();

    @Override
    public SipRequest clone();

    public static Builder invite(String requestURI) throws SipParseException {
        return SipRequest.request(Builder.INVITE, requestURI);
    }

    public static Builder ack(String requestURI) throws SipParseException {
        return SipRequest.request(Builder.ACK, requestURI);
    }

    public static Builder ack(SipURI requestURI) throws SipParseException {
        PreConditions.assertNotNull(requestURI, "RequestURI canot be null or the empty string");
        return new Builder(Builder.ACK, requestURI);
    }

    public static Builder cancel(SipURI requestURI) throws SipParseException {
        PreConditions.assertNotNull(requestURI, "RequestURI canot be null or the empty string");
        return new Builder(Builder.CANCEL, requestURI);
    }

    public static Builder cancel(String requestURI) throws SipParseException {
        return SipRequest.request(Builder.CANCEL, requestURI);
    }

    public static Builder request(Buffer method, String requestURI) throws SipParseException {
        PreConditions.assertNotEmpty(requestURI, "RequestURI canot be null or the empty string");
        try {
            SipURI uri = SipURI.frame(Buffers.wrap((String)requestURI));
            return new Builder(method, uri);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new SipParseException(0, "Unable to parse the request-uri", e);
        }
    }

    public static class Builder {
        private static final Buffer INVITE = Buffers.wrap((String)"INVITE");
        private static final Buffer ACK = Buffers.wrap((String)"ACK");
        private static final Buffer CANCEL = Buffers.wrap((String)"CANCEL");
        private final Buffer method;
        private final SipURI requestURI;
        private ToHeader to;
        private FromHeader from;
        private ContactHeader contact;
        private CSeqHeader cseq;
        private MaxForwardsHeader maxForwards;
        private CallIdHeader callId;
        private ViaHeader via;
        private List<ViaHeader> vias;

        private Builder(Buffer method, SipURI requestURI) {
            this.requestURI = requestURI;
            this.method = method;
        }

        public Builder to(ToHeader to) {
            this.to = PreConditions.assertNotNull(to, "The To-header cannot be null");
            return this;
        }

        public Builder from(FromHeader from) {
            this.from = PreConditions.assertNotNull(from, "The From-header cannot be null");
            return this;
        }

        public Builder callId(CallIdHeader callId) {
            this.callId = PreConditions.assertNotNull(callId, "The Call-ID header cannot be null");
            return this;
        }

        public Builder contact(ContactHeader contact) {
            this.contact = PreConditions.assertNotNull(contact, "The Contact-header cannot be null");
            return this;
        }

        public Builder cseq(CSeqHeader cseq) {
            this.cseq = PreConditions.assertNotNull(cseq, "The CSeq-header cannot be null");
            return this;
        }

        public Builder via(ViaHeader via) {
            PreConditions.assertNotNull(via, "The Via-header cannot be null");
            if (this.via == null) {
                this.via = via;
            } else {
                this.ensureViaList().add(via);
            }
            return this;
        }

        public SipRequest build() throws SipParseException {
            PreConditions.assertNotNull(this.from, "The From-header has not been specified");
            SipRequestLine initialLine = new SipRequestLine(this.method, this.requestURI);
            SipRequestImpl request = new SipRequestImpl(initialLine, null, null);
            request.setHeader(this.getToHeader());
            request.setHeader(this.from);
            request.setHeader(this.getCSeq());
            request.setHeader(this.getCallId());
            request.setHeader(this.getMaxForwards());
            if (this.via != null) {
                request.addHeader(this.via);
                if (this.vias != null) {
                    this.vias.forEach(via -> request.addHeader((SipHeader)via));
                }
            }
            if (this.contact != null) {
                request.setHeader(this.contact);
            }
            return request;
        }

        private MaxForwardsHeader getMaxForwards() {
            if (this.maxForwards == null) {
                this.maxForwards = MaxForwardsHeader.create();
            }
            return this.maxForwards;
        }

        private CallIdHeader getCallId() {
            if (this.callId == null) {
                this.callId = CallIdHeader.create();
            }
            return this.callId;
        }

        private CSeqHeader getCSeq() {
            if (this.cseq == null) {
                this.cseq = CSeqHeader.with().method(this.method).build();
            }
            return this.cseq;
        }

        private ToHeader getToHeader() {
            if (this.to == null) {
                Buffer user = this.requestURI.getUser();
                Buffer host = this.requestURI.getHost();
                this.to = (ToHeader)ToHeader.with().user(user).host(host).build();
            }
            return this.to;
        }

        private List<ViaHeader> ensureViaList() {
            if (this.vias == null) {
                this.vias = new ArrayList<ViaHeader>(2);
            }
            return this.vias;
        }
    }
}

