/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.List;

public interface SipMessage
extends Cloneable {
    public Buffer getInitialLine();

    public SipRequest toRequest() throws ClassCastException;

    public SipResponse toResponse() throws ClassCastException;

    public SipResponse createResponse(int var1) throws SipParseException, ClassCastException;

    public boolean isResponse();

    public boolean isRequest();

    public Object getContent() throws SipParseException;

    public Buffer getRawContent();

    public boolean hasContent();

    public Buffer getMethod() throws SipParseException;

    public SipHeader getHeader(Buffer var1) throws SipParseException;

    public SipHeader getHeader(String var1) throws SipParseException;

    public void addHeader(SipHeader var1) throws SipParseException;

    public void addHeaderFirst(SipHeader var1) throws SipParseException;

    public SipHeader popHeader(Buffer var1) throws SipParseException;

    public void setHeader(SipHeader var1) throws SipParseException;

    public FromHeader getFromHeader() throws SipParseException;

    public ToHeader getToHeader() throws SipParseException;

    public ViaHeader getViaHeader() throws SipParseException;

    public List<ViaHeader> getViaHeaders() throws SipParseException;

    public MaxForwardsHeader getMaxForwards() throws SipParseException;

    public RecordRouteHeader getRecordRouteHeader() throws SipParseException;

    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipParseException;

    public RouteHeader getRouteHeader() throws SipParseException;

    public List<RouteHeader> getRouteHeaders() throws SipParseException;

    public ExpiresHeader getExpiresHeader() throws SipParseException;

    public ContactHeader getContactHeader() throws SipParseException;

    public ContentTypeHeader getContentTypeHeader() throws SipParseException;

    public CallIdHeader getCallIDHeader() throws SipParseException;

    public CSeqHeader getCSeqHeader() throws SipParseException;

    public boolean isInvite() throws SipParseException;

    public boolean isRegister() throws SipParseException;

    public boolean isBye() throws SipParseException;

    public boolean isAck() throws SipParseException;

    public boolean isOptions() throws SipParseException;

    public boolean isMessage() throws SipParseException;

    public boolean isInfo() throws SipParseException;

    public boolean isCancel() throws SipParseException;

    public boolean isInitial() throws SipParseException;

    public void verify();

    public Buffer toBuffer();

    public SipMessage clone();

    public static SipMessage frame(Buffer buffer) throws SipParseException, IOException {
        PreConditions.assertNotNull(buffer);
        return SipParser.frame(buffer);
    }

    public static SipMessage frame(String buffer) throws SipParseException, IOException {
        PreConditions.assertNotEmpty(buffer, "Buffer cannot be null or the empty string");
        return SipParser.frame(Buffers.wrap((String)buffer));
    }
}

