/*
 * Decompiled with CFR 0.152.
 */
package textmogrify.lucene;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import java.io.Serializable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import textmogrify.lucene.AnalyzerBuilder;
import textmogrify.lucene.BrazilianPortugueseAnalyzerBuilder;
import textmogrify.lucene.Config;
import textmogrify.lucene.DutchAnalyzerBuilder;
import textmogrify.lucene.EnglishAnalyzerBuilder;
import textmogrify.lucene.FrenchAnalyzerBuilder;
import textmogrify.lucene.GermanAnalyzerBuilder;
import textmogrify.lucene.ItalianAnalyzerBuilder;
import textmogrify.lucene.PortugueseAnalyzerBuilder;
import textmogrify.lucene.SpanishAnalyzerBuilder;

public final class DefaultAnalyzerBuilder
extends AnalyzerBuilder {
    private final Config config;
    private final Set defaultStopWords;

    public DefaultAnalyzerBuilder(Config config) {
        this.config = config;
        super(config);
        this.defaultStopWords = Predef$.MODULE$.Set().empty();
    }

    @Override
    public Set<String> defaultStopWords() {
        return this.defaultStopWords;
    }

    @Override
    public DefaultAnalyzerBuilder withConfig(Config newConfig) {
        return new DefaultAnalyzerBuilder(newConfig);
    }

    @Override
    public EnglishAnalyzerBuilder english() {
        return new EnglishAnalyzerBuilder(this.config, false);
    }

    @Override
    public FrenchAnalyzerBuilder french() {
        return new FrenchAnalyzerBuilder(this.config, false);
    }

    @Override
    public GermanAnalyzerBuilder german() {
        return new GermanAnalyzerBuilder(this.config, false);
    }

    @Override
    public DutchAnalyzerBuilder dutch() {
        return new DutchAnalyzerBuilder(this.config, false);
    }

    @Override
    public BrazilianPortugueseAnalyzerBuilder brazilianPortuguese() {
        return new BrazilianPortugueseAnalyzerBuilder(this.config, false);
    }

    @Override
    public PortugueseAnalyzerBuilder portuguese() {
        return new PortugueseAnalyzerBuilder(this.config, false);
    }

    @Override
    public ItalianAnalyzerBuilder italian() {
        return new ItalianAnalyzerBuilder(this.config, false);
    }

    @Override
    public SpanishAnalyzerBuilder spanish() {
        return new SpanishAnalyzerBuilder(this.config, false);
    }

    @Override
    public <F> Resource<F, Analyzer> build(Sync<F> F) {
        return this.mkFromStandardTokenizer(this.config, (Function1<TokenStream, TokenStream>)(Function1 & Serializable)x -> (TokenStream)Predef$.MODULE$.identity(x), F);
    }
}

