/*
 * Decompiled with CFR 0.152.
 */
package textmogrify.lucene;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.package$;
import fs2.text;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.lucene.analysis.Analyzer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import textmogrify.lucene.AnalyzerPipe$;
import textmogrify.lucene.TokenGetter;

public abstract class AnalyzerPipe<F>
implements Product,
Serializable {
    private final Function1 readerF;
    private final Async<F> F;

    public static <F> AnalyzerPipe<F> fromResource(Resource<F, Analyzer> resource, Async<F> async) {
        return AnalyzerPipe$.MODULE$.fromResource(resource, async);
    }

    public static <F> AnalyzerPipe<F> unapply(AnalyzerPipe<F> analyzerPipe) {
        return AnalyzerPipe$.MODULE$.unapply(analyzerPipe);
    }

    public AnalyzerPipe(Function1<Reader, Resource<F, TokenGetter>> readerF, Async<F> F) {
        this.readerF = readerF;
        this.F = F;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AnalyzerPipe)) return false;
        AnalyzerPipe analyzerPipe = (AnalyzerPipe)object;
        Function1<Reader, Resource<F, TokenGetter>> function1 = this.readerF();
        Function1<Reader, Resource<F, TokenGetter>> function12 = analyzerPipe.readerF();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        if (!analyzerPipe.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AnalyzerPipe;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "AnalyzerPipe";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "readerF";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Function1<Reader, Resource<F, TokenGetter>> readerF() {
        return this.readerF;
    }

    private Resource<F, TokenGetter> streamToTokenGetter(Stream<F, Object> input) {
        return package$.MODULE$.toInputStreamResource(input, this.F).flatMap((Function1 & Serializable)in -> (Resource)this.readerF().apply((Object)new InputStreamReader((InputStream)in)));
    }

    public Stream<F, String> tokenizeBytes(Stream<F, Object> in, int tokenN) {
        Pull pull = Pull$.MODULE$.StreamPullOps(AnalyzerPipe.go$1(tokenN, Stream$.MODULE$.resource(this.streamToTokenGetter(in), this.F)));
        return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
    }

    public Stream<F, String> tokenizeStrings(Stream<F, String> in, int tokenN) {
        return this.tokenizeBytes(in.intersperse((Object)" ").through(text.utf8$.MODULE$.encode()), tokenN);
    }

    public Stream<F, String> tokenizeStringsRaw(Stream<F, String> in, int tokenN) {
        return this.tokenizeBytes(in.through(text.utf8$.MODULE$.encode()), tokenN);
    }

    public Function1<Reader, Resource<F, TokenGetter>> _1() {
        return this.readerF();
    }

    private static final Function1 loop$1(int tokenN$1) {
        return (Function1 & Serializable)tk -> {
            int iter;
            ArrayBuffer arr = new ArrayBuffer(tokenN$1);
            for (iter = 0; iter < tokenN$1 && tk.increment(); ++iter) {
                arr.append((Object)tk.string());
            }
            if (iter < tokenN$1) {
                return Pull$.MODULE$.output(Chunk$.MODULE$.indexedSeq((IndexedSeq)arr)).as((Object)None$.MODULE$);
            }
            return Pull$.MODULE$.output(Chunk$.MODULE$.indexedSeq((IndexedSeq)arr)).as((Object)Some$.MODULE$.apply(tk));
        };
    }

    private static final Pull go$1(int tokenN$3, Stream tokens) {
        Stream stream = Stream$.MODULE$.InvariantOps(tokens);
        Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream.ToPull$.MODULE$.uncons1$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                TokenGetter tk = (TokenGetter)tuple2._1();
                return (Pull)Pull$.MODULE$.loop(AnalyzerPipe.loop$1(tokenN$3)).apply((Object)tk);
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        });
    }
}

