/*
 * Decompiled with CFR 0.152.
 */
package textmogrify.lucene;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import java.io.Serializable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.es.SpanishLightStemFilter;
import scala.Function1;
import textmogrify.lucene.AnalyzerBuilder;
import textmogrify.lucene.Config;

public final class SpanishAnalyzerBuilder
extends AnalyzerBuilder {
    private final Config config;
    private final boolean stemmer;

    public SpanishAnalyzerBuilder(Config config, boolean stemmer) {
        this.config = config;
        this.stemmer = stemmer;
        super(config);
    }

    private SpanishAnalyzerBuilder copy(Config newConfig, boolean stemmer) {
        return new SpanishAnalyzerBuilder(newConfig, stemmer);
    }

    private boolean copy$default$2() {
        return this.stemmer;
    }

    @Override
    public SpanishAnalyzerBuilder withConfig(Config newConfig) {
        return this.copy(newConfig, this.copy$default$2());
    }

    public SpanishAnalyzerBuilder withSpanishLightStemmer() {
        return this.copy(this.config.copy(true, this.config.copy$default$2(), this.config.copy$default$3()), true);
    }

    @Override
    public <F> Resource<F, Analyzer> build(Sync<F> F) {
        return this.mkFromStandardTokenizer(this.config, (Function1<TokenStream, TokenStream>)(Function1 & Serializable)ts -> {
            if (this.stemmer) {
                return new SpanishLightStemFilter(ts);
            }
            return ts;
        }, F);
    }
}

