/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation.handler;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.SeleniumWebElementIncorrectType;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebSeleniumMessages;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.FileUtils;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.WebElement;

public class SeleniumUploadFromClasspath
implements EndpointHandler<Void> {
    private final List<String> resourcesToUpload;

    public SeleniumUploadFromClasspath(@NotNull List<String> resourcesToUpload) {
        this.resourcesToUpload = resourcesToUpload;
    }

    public Void handle(Object endpoint) {
        WebElement webElement = (WebElement)endpoint;
        String tagName = webElement.getTagName();
        if (!"input".equalsIgnoreCase(tagName)) {
            throw SeleniumWebElementIncorrectType.exception(PageFactoryWebSeleniumMessages.WEB_ELEMENT_INCORRECT_TYPE.getMessage(new Object[]{tagName, "input"}));
        }
        String fileNames = this.resourcesToUpload.stream().map(FileUtils::getRequiredFileFromClasspath).map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining("\n"));
        webElement.sendKeys(new CharSequence[]{fileNames});
        return null;
    }

    @NotNull
    public JsonNode toJson() {
        return JsonUtils.createObjectNode().put("name", "perfeccionista.js.selenium.GetWebElement").put("script", "js/GetWebElement.js");
    }
}

