/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation.handler;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserService;
import io.perfeccionista.framework.pagefactory.emulator.keys.Key;
import io.perfeccionista.framework.pagefactory.emulator.keys.KeyEventType;
import io.perfeccionista.framework.pagefactory.emulator.keys.KeyEventsChain;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import io.perfeccionista.framework.utils.ThreadUtils;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumSendKeyEvents
implements EndpointHandler<Void> {
    private final KeyEventsChain keyEvents;

    public SeleniumSendKeyEvents(@NotNull KeyEventsChain keyEvents) {
        this.keyEvents = keyEvents;
    }

    public Void handle(Object endpoint) {
        WebElement webElement = (WebElement)endpoint;
        WebBrowserService webBrowserService = (WebBrowserService)Environment.getCurrent().getService(WebBrowserService.class);
        RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webBrowserService.getActiveDispatcher().getInstance(RemoteWebDriver.class);
        this.keyEvents.getKeyEvents().forEach(keyEvent -> {
            Key key = keyEvent.getKey();
            KeyEventType type = keyEvent.getType();
            String charSequenceToInput = Keys.getKeyFromUnicode((char)key.getKeyCode()) == null ? String.valueOf(key.getKeyCode()) : Keys.getKeyFromUnicode((char)key.getKeyCode());
            switch (type) {
                case KEY_PRESS: {
                    webElement.sendKeys(new CharSequence[]{charSequenceToInput});
                    break;
                }
                case KEY_DOWN: {
                    new Actions((WebDriver)remoteWebDriver).keyDown(webElement, (CharSequence)charSequenceToInput).build().perform();
                    break;
                }
                case KEY_UP: {
                    new Actions((WebDriver)remoteWebDriver).keyUp(webElement, (CharSequence)charSequenceToInput).build().perform();
                }
            }
            ThreadUtils.sleep((Duration)keyEvent.getDelay());
        });
        return null;
    }

    @NotNull
    public JsonNode toJson() {
        return JsonUtils.createObjectNode().put("name", "perfeccionista.js.selenium.GetWebElement").put("script", "js/GetWebElement.js");
    }
}

