/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation.handler;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.measurements.Point2D;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.methods.WebHoverToAvailable;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumHoverTo
implements EndpointHandler<Void> {
    private final WebHoverToAvailable element;
    private final boolean withOutOfBounds;

    public SeleniumHoverTo(@NotNull WebHoverToAvailable element, boolean withOutOfBounds) {
        this.element = element;
        this.withOutOfBounds = withOutOfBounds;
    }

    public Void handle(Object endpoint) {
        WebElement webElement = (WebElement)endpoint;
        RemoteWebDriver webDriver = (RemoteWebDriver)this.element.getWebBrowserDispatcher().getInstance(RemoteWebDriver.class);
        if (this.withOutOfBounds) {
            Point2D location = ((WebChildElement)this.element).getElementBounds().getScreenLocation();
            double xShift = -(location.getX() - 10.0);
            double yShift = 0.0;
            new Actions((WebDriver)webDriver).moveToElement(webElement, (int)xShift, (int)yShift).build().perform();
        }
        new Actions((WebDriver)webDriver).moveToElement(webElement).build().perform();
        return null;
    }

    @NotNull
    public JsonNode toJson() {
        return JsonUtils.createObjectNode().put("name", "perfeccionista.js.selenium.GetWebElement").put("script", "js/GetWebElement.js");
    }
}

