/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.tabs;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.WebBrowserTabNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.mapper.ExceptionMapperResult;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import io.perfeccionista.framework.utils.UrlUtils;
import io.perfeccionista.framework.value.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumWebBrowserTabsDispatcher
implements WebBrowserTabsDispatcher {
    protected final Environment environment;
    protected final RemoteWebDriver instance;
    protected final WebExceptionMapper exceptionMapper;

    public SeleniumWebBrowserTabsDispatcher(Environment environment, RemoteWebDriver instance, WebExceptionMapper exceptionMapper) {
        this.environment = environment;
        this.instance = instance;
        this.exceptionMapper = exceptionMapper;
    }

    public int getTabCount() {
        return (Integer)((ExceptionMapperResult)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetTabCount", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.getWindowHandles().size()))).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    @NotNull
    public String getActiveTabTitle() {
        return (String)((ExceptionMapperResult)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetActiveTabTitle", (String[])new String[0]), () -> this.exceptionMapper.map(() -> ((RemoteWebDriver)this.instance).getTitle()))).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    @NotNull
    public String getActiveTabUrl() {
        return (String)((ExceptionMapperResult)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetActiveTabUrl", (String[])new String[0]), () -> this.exceptionMapper.map(() -> ((RemoteWebDriver)this.instance).getCurrentUrl()))).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    @NotNull
    public List<String> getAllTabTitles() {
        return (List)((ExceptionMapperResult)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetAllTabTitles", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.getWindowHandles().stream().map(windowHandle -> {
            this.instance.switchTo().window(windowHandle);
            return this.instance.getTitle();
        }).collect(Collectors.toList())))).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    @NotNull
    public List<String> getAllTabUrls() {
        return (List)((ExceptionMapperResult)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetAllTabUrls", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.getWindowHandles().stream().map(windowHandle -> {
            this.instance.switchTo().window(windowHandle);
            return this.instance.getCurrentUrl();
        }).collect(Collectors.toList())))).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    public SeleniumWebBrowserTabsDispatcher newTab() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"OpenEmptyTab", (String[])new String[0]), () -> this.exceptionMapper.map(() -> {
            this.instance.executeScript("window.open();", new Object[0]);
            ArrayList tabs = new ArrayList(this.instance.getWindowHandles());
            this.instance.switchTo().window((String)tabs.get(tabs.size() - 1));
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher newTab(@NotNull String absoluteUrl) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"OpenTabWithUrl", (String[])new String[]{absoluteUrl}), () -> this.exceptionMapper.map(() -> {
            this.instance.executeScript("window.open('" + absoluteUrl + "','_blank');", new Object[0]);
            ArrayList tabs = new ArrayList(this.instance.getWindowHandles());
            this.instance.switchTo().window((String)tabs.get(tabs.size() - 1));
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher refresh() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserRefresh", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.navigate().refresh()).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher back() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserBack", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.navigate().back()).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher openUrl(@NotNull String relativeOrAbsoluteUrl) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserOpenUrl", (String[])new String[]{relativeOrAbsoluteUrl}), () -> this.exceptionMapper.map(() -> {
            Object actualUrl = UrlUtils.isAbsoluteUrl((String)relativeOrAbsoluteUrl) ? relativeOrAbsoluteUrl : UrlUtils.withoutFollowingSlash((String)this.instance.getCurrentUrl()) + relativeOrAbsoluteUrl;
            this.instance.get((String)actualUrl);
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher closeActiveTab() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserCloseActiveTab", (String[])new String[0]), () -> this.exceptionMapper.map(() -> {
            Set windowHandles = this.instance.getWindowHandles();
            String currentHandle = this.instance.getWindowHandle();
            this.instance.close();
            windowHandles.stream().filter(handle -> !currentHandle.equals(handle)).findFirst().ifPresent(handle -> this.instance.switchTo().window(handle));
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher closeTabWithTitle(@NotNull Value<String> tabTitle) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserCloseTabWithTitle", (String[])new String[]{tabTitle.getShortDescription()}), () -> this.exceptionMapper.map(() -> {
            String currentHandle = this.instance.getWindowHandle();
            Set windowHandles = this.instance.getWindowHandles();
            HashSet windowTitles = new HashSet();
            String targetHandle = windowHandles.stream().filter(windowHandle -> {
                this.instance.switchTo().window(windowHandle);
                String currentTabTitle = this.instance.getTitle();
                windowTitles.add(currentTabTitle);
                return tabTitle.check((Object)currentTabTitle);
            }).findFirst().orElseThrow(() -> WebBrowserTabNotFound.exception((String)PageFactoryWebApiMessages.WEB_BROWSER_HAS_NO_TAB_WITH_TITLE.getMessage(new Object[]{tabTitle.get()})).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Browser tab titles", (Set)windowTitles)));
            if (windowHandles.size() == 1) {
                this.instance.close();
                return;
            }
            this.instance.switchTo().window(targetHandle);
            this.instance.close();
            if (this.instance.getWindowHandles().contains(currentHandle)) {
                this.instance.switchTo().window(currentHandle);
            }
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher closeTabWithUrl(@NotNull Value<String> tabUrl) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserCloseTabWithUrl", (String[])new String[]{tabUrl.getShortDescription()}), () -> this.exceptionMapper.map(() -> {
            String currentHandle = this.instance.getWindowHandle();
            Set windowHandles = this.instance.getWindowHandles();
            HashSet windowUrls = new HashSet();
            String targetHandle = windowHandles.stream().filter(windowHandle -> {
                this.instance.switchTo().window(windowHandle);
                String currentTabUrl = this.instance.getCurrentUrl();
                windowUrls.add(currentTabUrl);
                return tabUrl.check((Object)currentTabUrl);
            }).findFirst().orElseThrow(() -> WebBrowserTabNotFound.exception((String)PageFactoryWebApiMessages.WEB_BROWSER_HAS_NO_TAB_WITH_URL.getMessage(new Object[]{tabUrl.get()})).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Browser tab urls", (Set)windowUrls)));
            if (windowHandles.size() == 1) {
                this.instance.close();
                return;
            }
            this.instance.switchTo().window(targetHandle);
            this.instance.close();
            if (this.instance.getWindowHandles().contains(currentHandle)) {
                this.instance.switchTo().window(currentHandle);
            }
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher switchToTabWithTitle(@NotNull Value<String> tabTitle) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserSwitchToTabWithTitleMethod", (String[])new String[]{tabTitle.getShortDescription()}), () -> this.exceptionMapper.map(() -> {
            Set windowHandles = this.instance.getWindowHandles();
            HashSet windowTitles = new HashSet();
            String targetHandle = windowHandles.stream().filter(windowHandle -> {
                this.instance.switchTo().window(windowHandle);
                String currentTabTitle = this.instance.getTitle();
                windowTitles.add(currentTabTitle);
                return tabTitle.check((Object)currentTabTitle);
            }).findFirst().orElseThrow(() -> WebBrowserTabNotFound.exception((String)PageFactoryWebApiMessages.WEB_BROWSER_HAS_NO_TAB_WITH_TITLE.getMessage(new Object[]{tabTitle.get()})).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Browser tab titles", (Set)windowTitles)));
            this.instance.switchTo().window(targetHandle);
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher switchToTabWithUrl(@NotNull Value<String> tabUrl) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserSwitchToTabWithUrlMethod", (String[])new String[]{tabUrl.getShortDescription()}), () -> this.exceptionMapper.map(() -> {
            Set windowHandles = this.instance.getWindowHandles();
            HashSet windowUrls = new HashSet();
            String targetHandle = windowHandles.stream().filter(windowHandle -> {
                this.instance.switchTo().window(windowHandle);
                String currentTabUrl = this.instance.getCurrentUrl();
                windowUrls.add(currentTabUrl);
                return tabUrl.check((Object)currentTabUrl);
            }).findFirst().orElseThrow(() -> WebBrowserTabNotFound.exception((String)PageFactoryWebApiMessages.WEB_BROWSER_HAS_NO_TAB_WITH_URL.getMessage(new Object[]{tabUrl.get()})).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Browser tab urls", (Set)windowUrls)));
            this.instance.switchTo().window(targetHandle);
        }).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserTabsDispatcher should(@NotNull WebBrowserTabsDispatcherMatcher matcher) {
        matcher.check((WebBrowserTabsDispatcher)this);
        return this;
    }

    @NotNull
    public String getDescription() {
        return (String)this.exceptionMapper.map(() -> {
            StringBuilder sb = new StringBuilder();
            this.instance.getWindowHandles().forEach(windowHandle -> {
                this.instance.switchTo().window(windowHandle);
                String currentTabTitle = this.instance.getTitle();
                String currentTabUrl = this.instance.getCurrentUrl();
                sb.append(currentTabTitle).append("\n").append(currentTabUrl).append("\n");
            });
            return sb.toString();
        }).setResultIfException((Object)"unavailable").getResult();
    }
}

