/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.logs;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.pagefactory.dispatcher.logs.WebBrowserLogsDispatcher;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumWebBrowserLogsDispatcher
implements WebBrowserLogsDispatcher {
    protected final Environment environment;
    protected final RemoteWebDriver instance;
    protected final WebExceptionMapper exceptionMapper;

    public SeleniumWebBrowserLogsDispatcher(Environment environment, RemoteWebDriver instance, WebExceptionMapper exceptionMapper) {
        this.environment = environment;
        this.instance = instance;
        this.exceptionMapper = exceptionMapper;
    }

    @NotNull
    public Stream<String> getEntries() {
        return (Stream)this.exceptionMapper.map(() -> this.instance.manage().logs().get("browser").getAll().stream().map(LogEntry::toString)).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    public SeleniumWebBrowserLogsDispatcher setLogLevel(@NotNull Level level) {
        this.exceptionMapper.map(() -> this.instance.setLogLevel(level)).ifException(exception -> {
            throw exception;
        });
        return this;
    }
}

