/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.executor;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.HtmlAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.WebLocatorProcessingResult;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class SeleniumOperationExecutionResult<T> {
    private final EndpointHandler<T> endpointHandler;
    private final JsonNode searchHistoryNode;
    private final Map<Integer, T> values;
    private JsonNode errorNode = null;
    private JsonNode logsNode = null;
    private String outerHtml = "empty";

    private SeleniumOperationExecutionResult(Object result, @NotNull EndpointHandler<T> endpointHandler) {
        this.endpointHandler = endpointHandler;
        Map resultMap = (Map)result;
        this.searchHistoryNode = JsonUtils.parseJsonNode((String)resultMap.get("searchHistory").toString());
        if (resultMap.containsKey("error")) {
            this.errorNode = JsonUtils.parseJsonNode((String)resultMap.get("error").toString());
        }
        if (resultMap.containsKey("logs")) {
            this.logsNode = JsonUtils.parseJsonNode((String)resultMap.get("logs").toString());
        }
        if (resultMap.containsKey("outerHtml")) {
            this.outerHtml = resultMap.get("outerHtml").toString();
        }
        this.values = this.extractValues(resultMap.get("values"));
    }

    static <T> SeleniumOperationExecutionResult<T> of(Object result, @NotNull EndpointHandler<T> endpointHandler) {
        return new SeleniumOperationExecutionResult<T>(result, endpointHandler);
    }

    public boolean withLogs() {
        return this.logsNode != null;
    }

    public String getLogs() {
        return this.logsNode == null ? "" : this.logsNode.toPrettyString();
    }

    public JsonNode getLogsNode() {
        return this.logsNode;
    }

    public boolean withException() {
        return this.errorNode != null;
    }

    public PerfeccionistaRuntimeException getException(@NotNull WebExceptionMapper exceptionMapper) {
        return this.buildException(exceptionMapper);
    }

    public WebElementOperationResult<T> getSuccessfulOperationResult() {
        return WebElementOperationResult.of(this.extractSearchHistory(this.searchHistoryNode), this.values, (String)this.outerHtml);
    }

    public WebElementOperationResult<T> getUnsuccessfulOperationResult(WebExceptionMapper exceptionMapper) {
        PerfeccionistaRuntimeException exception = this.getException(exceptionMapper);
        if (this.withLogs()) {
            exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"JavaScript logs", (JsonNode)this.getLogsNode()));
        }
        return WebElementOperationResult.of(this.extractSearchHistory(this.searchHistoryNode), (WebExceptionMapper)exceptionMapper, (RuntimeException)exception, (String)this.outerHtml);
    }

    protected Map<String, Map<Integer, WebLocatorProcessingResult>> extractSearchHistory(JsonNode searchHistoryNode) {
        HashMap<String, Map<Integer, WebLocatorProcessingResult>> searchHistory = new HashMap<String, Map<Integer, WebLocatorProcessingResult>>();
        for (JsonNode searchHistoryEntry : searchHistoryNode) {
            String locatorId = searchHistoryEntry.get("locator").get("locatorId").asText();
            HashMap<Integer, WebLocatorProcessingResult> locatorResultsMap = new HashMap<Integer, WebLocatorProcessingResult>();
            for (JsonNode locatorResultEntry : searchHistoryEntry.get("result")) {
                int index = locatorResultEntry.has("index") ? locatorResultEntry.get("index").asInt() : -1;
                boolean found = locatorResultEntry.get("found").asBoolean();
                String hash = locatorResultEntry.has("hash") ? locatorResultEntry.get("hash").asText() : null;
                Boolean hashCorrect = locatorResultEntry.has("hashCorrect") ? Boolean.valueOf(locatorResultEntry.get("hashCorrect").asBoolean()) : null;
                locatorResultsMap.put(index, WebLocatorProcessingResult.of((long)index, (boolean)found, (String)hash, (Boolean)hashCorrect));
            }
            searchHistory.put(locatorId, locatorResultsMap);
        }
        return searchHistory;
    }

    protected Map<Integer, T> extractValues(Object valuesObject) {
        HashMap<Integer, Object> results = new HashMap<Integer, Object>();
        ArrayList values = (ArrayList)valuesObject;
        for (Map valueEntry : values) {
            Object value = valueEntry.get("value");
            Integer index = -1;
            if (valueEntry.containsKey("index")) {
                index = ((Long)valueEntry.get("index")).intValue();
            }
            results.put(index, value == null ? null : this.endpointHandler.handle(value));
        }
        return results;
    }

    protected PerfeccionistaRuntimeException buildException(@NotNull WebExceptionMapper exceptionMapper) {
        String errorName = this.errorNode.get("name").asText();
        String errorMessage = this.errorNode.get("message").asText();
        PerfeccionistaRuntimeException exception = exceptionMapper.createByName(errorName, errorMessage).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"JavaScript error stacktrace", (String)this.errorNode.get("stackTrace").asText()));
        for (JsonNode errorAttachmentEntry : this.errorNode.get("attachments")) {
            exception.addLastAttachmentEntry(this.resolveErrorAttachment(errorAttachmentEntry));
        }
        return exception;
    }

    protected AttachmentEntry<?> resolveErrorAttachment(JsonNode errorAttachmentEntry) {
        String attachmentType = errorAttachmentEntry.get("type").asText();
        if ("json".equals(attachmentType)) {
            return JsonAttachmentEntry.of((String)errorAttachmentEntry.get("name").asText(), (JsonNode)errorAttachmentEntry.get("content"));
        }
        if ("text/html".equals(attachmentType)) {
            return HtmlAttachmentEntry.of((String)errorAttachmentEntry.get("name").asText(), (String)errorAttachmentEntry.get("content").asText());
        }
        return TextAttachmentEntry.of((String)errorAttachmentEntry.get("name").asText(), (String)errorAttachmentEntry.get("content").asText());
    }
}

