/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.executor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.base.UnclassifiedPerfeccionistaException;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.pagefactory.operation.handler.base.ExecuteOperation;
import io.perfeccionista.framework.pagefactory.operation.handler.base.LoadJsFunctions;
import io.perfeccionista.framework.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumJsFunctionRepository {
    protected static final Map<String, String> jsFunctionsCache = new ConcurrentHashMap<String, String>();
    private final RemoteWebDriver instance;
    private Set<String> loadedJsFunctions = new HashSet<String>();

    public SeleniumJsFunctionRepository(RemoteWebDriver instance) {
        this.instance = instance;
        this.init();
    }

    protected void init() {
        this.loadedJsFunctions.clear();
        HashSet<String> jsFunctionsToLoad = new HashSet<String>();
        this.addScriptToCache((EndpointHandler<?>)new LoadJsFunctions());
        this.addScriptToCache((EndpointHandler<?>)new ExecuteOperation());
        jsFunctionsToLoad.add("perfeccionista.js.selenium.ExecuteOperation");
        this.loadJsFunctions(jsFunctionsToLoad);
    }

    public void prepareOperation(WebElementOperation<?> operation) {
        HashSet<String> jsFunctionsToLoad = new HashSet<String>();
        operation.getRequiredFunctions().forEach(endpointHandler -> {
            JsonNode functionInvocation = endpointHandler.toJson();
            String functionName = functionInvocation.get("name").asText();
            String functionPath = functionInvocation.get("script").asText();
            if (!this.loadedJsFunctions.contains(functionName)) {
                jsFunctionsToLoad.add(functionName);
                if (!jsFunctionsCache.containsKey(functionName)) {
                    jsFunctionsCache.put(functionName, this.getScript(functionPath));
                }
            }
        });
        if (!jsFunctionsToLoad.isEmpty()) {
            this.loadJsFunctions(jsFunctionsToLoad);
        }
    }

    protected void loadJsFunctions(Set<String> jsFunctionsToLoad) {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        ArrayNode scriptsToLoadArrayNode = rootNode.putArray("scriptsToLoad");
        jsFunctionsToLoad.forEach(scriptName -> {
            ObjectNode scriptToLoadNode = JsonUtils.createObjectNode().put("scriptName", scriptName);
            ArrayNode scriptRowsNode = scriptToLoadNode.putArray("scriptContent");
            Arrays.stream(jsFunctionsCache.get(scriptName).split("\n")).forEachOrdered(arg_0 -> ((ArrayNode)scriptRowsNode).add(arg_0));
            scriptsToLoadArrayNode.add((JsonNode)scriptToLoadNode);
            this.loadedJsFunctions.add((String)scriptName);
        });
        this.instance.executeScript(jsFunctionsCache.get("perfeccionista.js.selenium.LoadJsFunctions"), new Object[]{JsonUtils.toPrettyJson((JsonNode)rootNode)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String getScript(@NotNull String resourcePath) {
        try (InputStream is = SeleniumJsFunctionRepository.class.getClassLoader().getResourceAsStream(resourcePath);){
            String string;
            if (Objects.isNull(is)) {
                throw new UnclassifiedPerfeccionistaException("Required js script is not found");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException e) {
            throw new UnclassifiedPerfeccionistaException(e.getMessage(), (Throwable)e);
        }
    }

    protected void addScriptToCache(@NotNull EndpointHandler<?> endpointHandler) {
        JsonNode functionInvocation = endpointHandler.toJson();
        String functionName = functionInvocation.get("name").asText();
        String functionPath = functionInvocation.get("script").asText();
        jsFunctionsCache.put(functionName, this.getScript(functionPath));
    }
}

