/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.cookies;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.pagefactory.dispatcher.cookies.Cookie;
import io.perfeccionista.framework.pagefactory.dispatcher.cookies.SeleniumCookieConverter;
import io.perfeccionista.framework.pagefactory.dispatcher.cookies.WebBrowserCookiesDispatcher;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumWebBrowserCookiesDispatcher
implements WebBrowserCookiesDispatcher {
    protected final Environment environment;
    protected final RemoteWebDriver instance;
    protected final WebExceptionMapper exceptionMapper;

    public SeleniumWebBrowserCookiesDispatcher(Environment environment, RemoteWebDriver instance, WebExceptionMapper exceptionMapper) {
        this.environment = environment;
        this.instance = instance;
        this.exceptionMapper = exceptionMapper;
    }

    @Nullable
    public Cookie getCookieByName(@NotNull String name) {
        return (Cookie)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetCookieByName", (String[])new String[]{name}), () -> (Cookie)this.exceptionMapper.map(() -> SeleniumCookieConverter.createPerfeccionistaCookie(this.instance.manage().getCookieNamed(name))).ifException(exception -> {
            throw exception;
        }).getResult());
    }

    @NotNull
    public Stream<Cookie> getCookies() {
        return (Stream)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetCookies", (String[])new String[0]), () -> (Stream)this.exceptionMapper.map(() -> this.instance.manage().getCookies().stream().map(SeleniumCookieConverter::createPerfeccionistaCookie)).ifException(exception -> {
            throw exception;
        }).getResult());
    }

    public SeleniumWebBrowserCookiesDispatcher addCookie(@NotNull Cookie cookie) {
        InvocationInfo invocationInfo = InvocationInfo.actionInvocation((String)"BrowserAddCookie", (String[])new String[0]).addAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Cookie", (String)cookie.toFormattedString()));
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationInfo, () -> this.exceptionMapper.map(() -> this.instance.manage().addCookie(SeleniumCookieConverter.createSeleniumCookie(cookie))).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserCookiesDispatcher cleanCookies() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserCleanCookies", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.manage().deleteAllCookies()).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserCookiesDispatcher deleteCookie(@NotNull Cookie cookie) {
        InvocationInfo invocationInfo = InvocationInfo.actionInvocation((String)"BrowserDeleteCookie", (String[])new String[0]).addAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Cookie", (String)cookie.toFormattedString()));
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationInfo, () -> this.exceptionMapper.map(() -> this.instance.manage().deleteCookie(SeleniumCookieConverter.createSeleniumCookie(cookie))).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserCookiesDispatcher deleteCookieByName(@NotNull String name) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserDeleteCookieByName", (String[])new String[]{name}), () -> this.exceptionMapper.map(() -> this.instance.manage().deleteCookieNamed(name)).ifException(exception -> {
            throw exception;
        }));
        return this;
    }
}

