/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher;

import com.google.common.collect.ImmutableMap;
import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.SeleniumWebDriverInstantiation;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebSeleniumMessages;
import io.perfeccionista.framework.pagefactory.dispatcher.AbstractWebBrowserSeleniumDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.type.RemoteType;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.OkHttpClient;

public class RemoteWebBrowserSeleniumDispatcher
extends AbstractWebBrowserSeleniumDispatcher<RemoteWebDriver, MutableCapabilities> {
    protected URL remoteUrl;

    public RemoteWebBrowserSeleniumDispatcher(Environment environment, String remoteUrl) {
        super(environment, new RemoteType());
        try {
            this.remoteUrl = new URL(remoteUrl);
        }
        catch (MalformedURLException e) {
            throw SeleniumWebDriverInstantiation.exception(PageFactoryWebSeleniumMessages.INCORRECT_REMOTE_WEB_DRIVER_INSTANCE_URL.getMessage(new Object[]{remoteUrl}), e);
        }
    }

    public RemoteWebBrowserSeleniumDispatcher(Environment environment, URL remoteUrl) {
        super(environment, new RemoteType());
        this.remoteUrl = remoteUrl;
    }

    public WebBrowserDispatcher launch() {
        long connectionTimeout = this.timeouts.getSessionTimeout();
        long socketTimeout = this.timeouts.getSessionTimeout() + 30000L;
        RemoteWebDriverConnectionFactory factory = new RemoteWebDriverConnectionFactory().connectionTimeout(Duration.ofSeconds(connectionTimeout)).socketTimeout(Duration.ofSeconds(socketTimeout));
        HttpCommandExecutor httpCommandExecutor = new HttpCommandExecutor((Map)ImmutableMap.of(), this.remoteUrl, (HttpClient.Factory)factory);
        this.instance = new RemoteWebDriver((CommandExecutor)httpCommandExecutor, (Capabilities)this.options);
        this.instance.setFileDetector((FileDetector)new LocalFileDetector());
        this.setTimeouts();
        return this;
    }

    static class RemoteWebDriverConnectionFactory
    extends OkHttpClient.Factory {
        private Duration connectionTimeout;
        private Duration socketTimeout;

        RemoteWebDriverConnectionFactory() {
        }

        RemoteWebDriverConnectionFactory connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        RemoteWebDriverConnectionFactory socketTimeout(Duration socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public HttpClient.Builder builder() {
            return super.builder().connectionTimeout(this.connectionTimeout).readTimeout(this.socketTimeout);
        }
    }
}

