/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.exceptions.mapper;

import io.perfeccionista.framework.exceptions.ElementNotDisplayed;
import io.perfeccionista.framework.exceptions.SeleniumStaleBrowserEnvironment;
import io.perfeccionista.framework.exceptions.SeleniumStaleWebElementReference;
import io.perfeccionista.framework.exceptions.SeleniumWebDriverInstance;
import io.perfeccionista.framework.exceptions.SeleniumWebDriverInstanceNotAvailable;
import io.perfeccionista.framework.exceptions.SeleniumWebElementNotIntractable;
import io.perfeccionista.framework.exceptions.WebElementIsDisabled;
import io.perfeccionista.framework.exceptions.WebElementNotClickable;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.base.UnclassifiedPerfeccionistaException;
import io.perfeccionista.framework.exceptions.js.JsElementSearch;
import io.perfeccionista.framework.exceptions.js.JsElementState;
import io.perfeccionista.framework.exceptions.js.JsExecution;
import io.perfeccionista.framework.exceptions.js.JsFunctionCall;
import io.perfeccionista.framework.exceptions.js.JsIncorrectSearchQuery;
import io.perfeccionista.framework.exceptions.mapper.ExceptionMapperResult;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebSeleniumMessages;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElementBase;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.ElementNotSelectableException;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.ConnectionClosedException;

public class SeleniumExceptionMapper
implements WebExceptionMapper {
    protected static final Pattern EXECUTE_OPERATION_NOT_LOADED = Pattern.compile("javascript error: executeOperation is not a function");
    protected static final Pattern START_REMOTE_WEB_DRIVER_SESSION_ERROR_PATTERN = Pattern.compile("(Could not start a new session)+");
    protected static final Pattern REMOTE_BROWSER_COMMUNICATION_ERROR_PATTERN = Pattern.compile("(Error communicating with the remote browser. It may have died)+");
    protected static final Pattern INVALID_SESSION_ID_PATTERN = Pattern.compile("(invalid session id)+");
    protected static final Pattern START_CONTAINER_ERROR_PATTERN = Pattern.compile("(start container: Error response from daemon: OCI runtime create failed:)+");
    protected static final Pattern START_SESSION_ERROR_PATTERN = Pattern.compile("(New session attempts retry count exceeded)+");
    protected static final Pattern PAGE_CRASH_PATTERN = Pattern.compile("(session deleted because of page crash)+");
    protected static final Pattern UNKNOWN_WEBDRIVER_ERROR_PATTERN = Pattern.compile("(An unknown error has occurred)+");
    protected static final Pattern CHROME_FAILED_TO_START_PATTERN = Pattern.compile("(Chrome failed to start)+");
    protected static final Pattern NO_SUCH_DOCKER_IMAGE_PATTERN = Pattern.compile("(create container: Error: No such image:)+");
    protected static final Pattern REMOTE_WEB_DRIVER_DOES_NOT_RESPOND_PATTERN = Pattern.compile("(wait: http(s)*://\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:\\d{1,5} does not respond in \\d+s)+");
    protected static final Pattern LOCAL_STORAGE_PROPERTY_NOT_AVAILABLE_PATTERN = Pattern.compile("(Failed to read the 'localStorage' property from 'Window')+");
    protected static final Pattern ERROR_CONNECTION_REFUSED = Pattern.compile("(unknown error: net::ERR_CONNECTION_REFUSED)+");

    @NotNull
    public PerfeccionistaRuntimeException mapElementException(@NotNull WebChildElementBase element, @NotNull RuntimeException exception) {
        if (exception instanceof PerfeccionistaRuntimeException) {
            return (PerfeccionistaRuntimeException)exception;
        }
        if (exception instanceof ElementClickInterceptedException) {
            return WebElementNotClickable.exception((String)PageFactoryWebSeleniumMessages.WEB_ELEMENT_CLICK_INTERCEPTED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()}), (Throwable)exception).setProcessed(true);
        }
        if (exception instanceof ElementNotVisibleException || exception instanceof NoSuchElementException) {
            return ElementNotDisplayed.exception((String)PageFactoryApiMessages.ELEMENT_NOT_DISPLAYED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()}), (Throwable)exception).setProcessed(true);
        }
        if (exception instanceof ElementNotInteractableException || exception instanceof ElementNotSelectableException) {
            return WebElementIsDisabled.exception((String)PageFactoryWebApiMessages.ELEMENT_IS_DISABLED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()}), (Throwable)exception).setProcessed(true);
        }
        if (exception instanceof InvalidElementStateException || exception instanceof MoveTargetOutOfBoundsException || exception instanceof InvalidCoordinatesException) {
            return SeleniumWebElementNotIntractable.exception(PageFactoryWebSeleniumMessages.ELEMENT_IS_NOT_INTRACTABLE.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()}), exception).setProcessed(true);
        }
        if (exception instanceof StaleElementReferenceException) {
            return SeleniumStaleWebElementReference.exception(PageFactoryWebSeleniumMessages.WEB_ELEMENT_IS_STALE.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()}), exception).setProcessed(true);
        }
        if (exception instanceof InvalidArgumentException || exception instanceof ErrorHandler.UnknownServerException || exception instanceof UnsupportedCommandException) {
            return SeleniumWebDriverInstance.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INTERNAL_ERROR.getMessage(new Object[0]), exception).setService(true);
        }
        if (exception instanceof UnreachableBrowserException || exception instanceof NoSuchSessionException || exception instanceof SessionNotCreatedException || exception instanceof ConnectionClosedException) {
            return this.mapSeleniumWebDriverInstanceNotAvailableException((WebDriverException)exception);
        }
        if (exception instanceof JavascriptException) {
            return this.mapJavaScriptException((JavascriptException)exception);
        }
        if (exception instanceof WebDriverException) {
            return this.mapUnclassifiedWebDriverException((WebDriverException)exception);
        }
        return new UnclassifiedPerfeccionistaException("Unexpected exception occurred", (Throwable)exception);
    }

    @NotNull
    public PerfeccionistaRuntimeException mapPageException(@NotNull WebPage page, @NotNull RuntimeException exception) {
        return null;
    }

    @NotNull
    public PerfeccionistaRuntimeException map(@NotNull RuntimeException exception) {
        return null;
    }

    @NotNull
    public <T> ExceptionMapperResult<T> map(@NotNull Supplier<T> supplier) {
        try {
            T result = supplier.get();
            return ExceptionMapperResult.success(result);
        }
        catch (WebDriverException e) {
            return ExceptionMapperResult.failure((PerfeccionistaRuntimeException)this.mapWebDriverException(e));
        }
    }

    @NotNull
    public ExceptionMapperResult<Void> map(@NotNull Runnable runnable) {
        try {
            runnable.run();
            return ExceptionMapperResult.empty();
        }
        catch (WebDriverException e) {
            return ExceptionMapperResult.failure((PerfeccionistaRuntimeException)this.mapWebDriverException(e));
        }
    }

    @NotNull
    public PerfeccionistaRuntimeException mapJavaScriptException(@NotNull JavascriptException exception) {
        String message = exception.getMessage();
        if (EXECUTE_OPERATION_NOT_LOADED.matcher(message).find()) {
            return SeleniumStaleBrowserEnvironment.exception(PageFactoryWebSeleniumMessages.WEB_BROWSER_ENVIRONMENT_IS_STALE.getMessage(new Object[0]), (Throwable)exception).setProcessed(true);
        }
        return this.mapUnclassifiedWebDriverException((WebDriverException)exception);
    }

    @NotNull
    public PerfeccionistaRuntimeException mapWebDriverException(@NotNull WebDriverException e) {
        if (e instanceof InvalidArgumentException || e instanceof ErrorHandler.UnknownServerException || e instanceof UnsupportedCommandException) {
            return SeleniumWebDriverInstance.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INTERNAL_ERROR.getMessage(new Object[0]), e).setService(true);
        }
        if (e instanceof UnreachableBrowserException || e instanceof NoSuchSessionException || e instanceof SessionNotCreatedException || e instanceof ConnectionClosedException) {
            return this.mapSeleniumWebDriverInstanceNotAvailableException(e);
        }
        return this.mapUnclassifiedWebDriverException(e);
    }

    @NotNull
    protected PerfeccionistaRuntimeException mapSeleniumWebDriverInstanceNotAvailableException(@NotNull WebDriverException exception) {
        String message = exception.getMessage();
        if (START_REMOTE_WEB_DRIVER_SESSION_ERROR_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (REMOTE_BROWSER_COMMUNICATION_ERROR_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_NOT_AVAILABLE.getMessage(new Object[0]), exception).setService(true);
        }
        if (INVALID_SESSION_ID_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_NOT_AVAILABLE.getMessage(new Object[0]), exception).setService(true);
        }
        return SeleniumWebDriverInstanceNotAvailable.exception(exception.getMessage(), exception).setService(true);
    }

    @NotNull
    protected PerfeccionistaRuntimeException mapUnclassifiedWebDriverException(WebDriverException exception) {
        String message = exception.getMessage();
        if (START_CONTAINER_ERROR_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (START_SESSION_ERROR_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (START_REMOTE_WEB_DRIVER_SESSION_ERROR_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (REMOTE_WEB_DRIVER_DOES_NOT_RESPOND_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (CHROME_FAILED_TO_START_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (NO_SUCH_DOCKER_IMAGE_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INITIALIZATION_FAILED.getMessage(new Object[0]), exception).setService(true);
        }
        if (PAGE_CRASH_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_NOT_AVAILABLE.getMessage(new Object[0]), exception).setService(true);
        }
        if (UNKNOWN_WEBDRIVER_ERROR_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_NOT_AVAILABLE.getMessage(new Object[0]), exception).setService(true);
        }
        if (LOCAL_STORAGE_PROPERTY_NOT_AVAILABLE_PATTERN.matcher(message).find()) {
            return SeleniumWebDriverInstanceNotAvailable.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_CAN_NOT_EXECUTE_OPERATION_ON_EMPTY_TAB.getMessage(new Object[0]), exception).setService(true);
        }
        if (ERROR_CONNECTION_REFUSED.matcher(message).find()) {
            return SeleniumWebDriverInstance.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_CONNECTION_REFUSED.getMessage(new Object[0]), exception).setService(true);
        }
        return SeleniumWebDriverInstance.exception(exception.getMessage(), exception).setService(true);
    }

    @NotNull
    public PerfeccionistaRuntimeException createByName(@NotNull String name, @NotNull String message) {
        switch (name) {
            case "IncorrectSearchQueryError": {
                return JsIncorrectSearchQuery.exception((String)message);
            }
            case "ElementSearchError": {
                return JsElementSearch.exception((String)message).setProcessed(true);
            }
            case "ElementStateError": {
                return JsElementState.exception((String)message).setProcessed(true);
            }
            case "FunctionCallError": {
                return JsFunctionCall.exception((String)message);
            }
        }
        return JsExecution.exception((String)message).setProcessed(true);
    }
}

