/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.window;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.measurements.Dimensions2D;
import io.perfeccionista.framework.measurements.Point2D;
import io.perfeccionista.framework.pagefactory.dispatcher.executor.WebBrowserOperationExecutor;
import io.perfeccionista.framework.pagefactory.dispatcher.window.SeleniumDimensionsConverter;
import io.perfeccionista.framework.pagefactory.dispatcher.window.WebBrowserWindowDispatcher;
import io.perfeccionista.framework.screenshots.PngScreenshot;
import io.perfeccionista.framework.screenshots.Screenshot;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumWebBrowserWindowDispatcher
implements WebBrowserWindowDispatcher {
    protected final Environment environment;
    protected final RemoteWebDriver instance;
    protected final WebBrowserOperationExecutor operationExecutor;
    protected final WebExceptionMapper exceptionMapper;

    public SeleniumWebBrowserWindowDispatcher(Environment environment, RemoteWebDriver instance, WebExceptionMapper exceptionMapper, WebBrowserOperationExecutor operationExecutor) {
        this.environment = environment;
        this.instance = instance;
        this.operationExecutor = operationExecutor;
        this.exceptionMapper = exceptionMapper;
    }

    @NotNull
    public Screenshot getPageScreenshot() {
        return (Screenshot)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetPageScreenshot", (String[])new String[0]), () -> (PngScreenshot)this.exceptionMapper.map(() -> PngScreenshot.from((byte[])((byte[])this.instance.getScreenshotAs(OutputType.BYTES)))).ifException(exception -> {
            throw exception;
        }).getResult());
    }

    @NotNull
    public Dimensions2D getInnerWindowSize() {
        return (Dimensions2D)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetInnerWindowSize", (String[])new String[0]), () -> (Dimensions2D)this.exceptionMapper.map(() -> {
            String script = "return window.innerWidth + 'x' + window.innerHeight;";
            return SeleniumDimensionsConverter.createPerfeccionistaDimensions((String)this.operationExecutor.executeScript(String.class, script, new Object[0]));
        }).ifException(exception -> {
            throw exception;
        }).getResult());
    }

    @NotNull
    public Dimensions2D getOuterWindowSize() {
        return (Dimensions2D)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetOuterWindowSize", (String[])new String[0]), () -> (Dimensions2D)this.exceptionMapper.map(() -> {
            String script = "return window.outerWidth + 'x' + window.outerHeight;";
            return SeleniumDimensionsConverter.createPerfeccionistaDimensions((String)this.operationExecutor.executeScript(String.class, script, new Object[0]));
        }).ifException(exception -> {
            throw exception;
        }).getResult());
    }

    public SeleniumWebBrowserWindowDispatcher setOuterWindowSize(@NotNull Dimensions2D windowSize) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserSetOuterWindowSize", (String[])new String[]{windowSize.toString()}), () -> this.exceptionMapper.map(() -> this.instance.manage().window().setSize(new Dimension(windowSize.getWidthAsInt(), windowSize.getHeightAsInt()))).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    @NotNull
    public Point2D getAbsoluteLocation() {
        return (Point2D)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetAbsoluteWindowLocation", (String[])new String[0]), () -> (Point2D)this.exceptionMapper.map(() -> SeleniumDimensionsConverter.createPerfeccionistaLocation(this.instance.manage().window().getPosition())).ifException(exception -> {
            throw exception;
        }).getResult());
    }

    public SeleniumWebBrowserWindowDispatcher setAbsoluteLocation(@NotNull Point2D location) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserSetAbsoluteWindowLocation", (String[])new String[]{location.toString()}), () -> this.exceptionMapper.map(() -> this.instance.manage().window().setPosition(new Point(location.getXAsInt(), location.getYAsInt()))).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserWindowDispatcher fullscreen() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserSetWindowFullscreen", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.manage().window().fullscreen()).ifException(exception -> {
            throw exception;
        }));
        return this;
    }

    public SeleniumWebBrowserWindowDispatcher maximize() {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.actionInvocation((String)"BrowserSetWindowMaximized", (String[])new String[0]), () -> this.exceptionMapper.map(() -> this.instance.manage().window().maximize()).ifException(exception -> {
            throw exception;
        }));
        return this;
    }
}

