/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.window;

import io.perfeccionista.framework.exceptions.WebBrowserDimensions;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.measurements.Dimensions2D;
import io.perfeccionista.framework.measurements.Point2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.Point;

public class SeleniumDimensionsConverter {
    private static final Pattern DIMENSIONS_PATTERN = Pattern.compile("^(?<width>\\d+)x(?<height>\\d+)$");

    private SeleniumDimensionsConverter() {
    }

    @NotNull
    public static Dimensions2D createPerfeccionistaDimensions(@NotNull String dimensions) {
        Matcher matcher = DIMENSIONS_PATTERN.matcher(dimensions);
        if (matcher.find()) {
            int width = Integer.parseInt(matcher.group("width"));
            int height = Integer.parseInt(matcher.group("height"));
            return Dimensions2D.of((double)width, (double)height);
        }
        throw WebBrowserDimensions.exception((String)PageFactoryWebApiMessages.WEB_BROWSER_DIMENSIONS_FORMAT_UNSUPPORTED.getMessage(new Object[]{dimensions}));
    }

    @NotNull
    public static Point2D createPerfeccionistaLocation(@NotNull Point point) {
        return Point2D.of((double)point.getX(), (double)point.getY());
    }
}

