/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.executor;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.ClassCanNotBeCast;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.UtilsMessages;
import io.perfeccionista.framework.logging.Logger;
import io.perfeccionista.framework.logging.LoggerFactory;
import io.perfeccionista.framework.pagefactory.dispatcher.executor.SeleniumJsFunctionRepository;
import io.perfeccionista.framework.pagefactory.dispatcher.executor.SeleniumOperationExecutionResult;
import io.perfeccionista.framework.pagefactory.dispatcher.executor.WebBrowserOperationExecutor;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.CastUtils;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumWebBrowserOperationExecutor
implements WebBrowserOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(SeleniumWebBrowserOperationExecutor.class);
    private static final String LAUNCH_OPERATION_EXECUTING = "return evaluate(arguments);\n\nfunction evaluate(arguments) {\n    let executeOperation = eval(window.localStorage.getItem('perfeccionista.js.selenium.ExecuteOperation'));\n    return executeOperation(JSON.parse(arguments[0]));\n}";
    protected final Environment environment;
    protected final RemoteWebDriver instance;
    protected final WebExceptionMapper exceptionMapper;
    protected SeleniumJsFunctionRepository jsRepository;
    protected boolean withLogs = false;

    public SeleniumWebBrowserOperationExecutor(Environment environment, RemoteWebDriver instance, WebExceptionMapper exceptionMapper) {
        this.environment = environment;
        this.instance = instance;
        this.exceptionMapper = exceptionMapper;
    }

    public SeleniumWebBrowserOperationExecutor withJsLogs() {
        this.withLogs = true;
        return this;
    }

    public <T> WebElementOperationResult<T> executeWebElementOperation(@NotNull WebElementOperation<T> operation) {
        if (Objects.isNull(this.jsRepository)) {
            this.jsRepository = new SeleniumJsFunctionRepository(this.instance);
        }
        this.jsRepository.prepareOperation(operation);
        if (this.withLogs) {
            operation.withLogs();
        }
        try {
            Object scriptResult = this.instance.executeScript(LAUNCH_OPERATION_EXECUTING, new Object[]{JsonUtils.toPrettyJson((JsonNode)operation.toJson())});
            EndpointHandler endpointHandler = operation.getOperationType().getEndpointHandler();
            SeleniumOperationExecutionResult result = SeleniumOperationExecutionResult.of(scriptResult, endpointHandler);
            if (this.withLogs && result.withLogs()) {
                log.info(result::getLogs);
            }
            if (result.withException()) {
                return result.getUnsuccessfulOperationResult(this.exceptionMapper);
            }
            return result.getSuccessfulOperationResult();
        }
        catch (RuntimeException exception) {
            if (exception instanceof JavascriptException && exception.getMessage().contains("executeOperation is not a function")) {
                this.jsRepository.init();
            }
            return WebElementOperationResult.of((WebExceptionMapper)this.exceptionMapper, (RuntimeException)exception);
        }
    }

    public Object executeScript(@NotNull String script, Object ... args) {
        return this.exceptionMapper.map(() -> this.instance.executeScript(script, args)).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    public <T> T executeScript(@NotNull Class<T> returnType, @NotNull String script, Object ... args) {
        return (T)this.exceptionMapper.map(() -> {
            Object result = this.instance.executeScript(script, args);
            if (CastUtils.isSubtypeOf((Object)result, (Class)returnType)) {
                return result;
            }
            throw ClassCanNotBeCast.exception((String)UtilsMessages.CANT_CAST_OBJECT.getMessage(new Object[]{result.getClass().getCanonicalName(), returnType.getCanonicalName()}));
        }).ifException(exception -> {
            throw exception;
        }).getResult();
    }
}

