/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.cookies;

import io.perfeccionista.framework.pagefactory.dispatcher.cookies.Cookie;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class SeleniumCookieConverter {
    @Nullable
    public static Cookie createPerfeccionistaCookie(@Nullable org.openqa.selenium.Cookie cookie) {
        if (Objects.isNull(cookie)) {
            return null;
        }
        Cookie convertedCookie = Cookie.of((String)cookie.getName(), (String)cookie.getValue()).setDomain(cookie.getDomain()).setPath(cookie.getPath()).setSecure(cookie.isSecure()).setHttpOnly(cookie.isHttpOnly());
        if (Objects.nonNull(cookie.getExpiry())) {
            convertedCookie.setExpirationDate(LocalDateTime.ofInstant(cookie.getExpiry().toInstant(), ZoneId.systemDefault()));
        }
        return convertedCookie;
    }

    @Nullable
    public static org.openqa.selenium.Cookie createSeleniumCookie(Cookie cookie) {
        if (Objects.isNull(cookie)) {
            return null;
        }
        return new org.openqa.selenium.Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), Objects.isNull(cookie.getExpirationDate()) ? null : Date.from(cookie.getExpirationDate().atZone(ZoneId.systemDefault()).toInstant()), cookie.isSecure(), cookie.isHttpOnly());
    }
}

