/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.context;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.PageNotInitialized;
import io.perfeccionista.framework.exceptions.mapper.ExceptionMapperResult;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.pagefactory.WebPageService;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.context.WebPageContext;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentElement;
import io.perfeccionista.framework.pagefactory.limiter.WebContextLimiter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DefaultWebPageContext
implements WebPageContext {
    protected final Environment environment;
    protected final WebBrowserDispatcher dispatcher;
    protected final WebExceptionMapper exceptionMapper;
    protected final Deque<WebContextLimiter<?>> contextLimiters = new ArrayDeque();
    protected WebPage activeWebPage = null;

    public DefaultWebPageContext(@NotNull Environment environment, @NotNull WebBrowserDispatcher dispatcher, @NotNull WebExceptionMapper exceptionMapper) {
        this.environment = environment;
        this.dispatcher = dispatcher;
        this.exceptionMapper = exceptionMapper;
    }

    public <T extends WebParentElement> WebPageContext execute(@NotNull Consumer<T> contextConsumer) {
        this.getContexts(this.contextLimiters).map(webParentElement -> webParentElement).forEachOrdered(contextConsumer);
        return this;
    }

    public <T extends WebParentElement> WebPageContext execute(@NotNull Consumer<T> contextConsumer, WebContextLimiter<?> ... limiterSequence) {
        ArrayDeque processedContextLimiters = new ArrayDeque(this.contextLimiters);
        for (WebContextLimiter<?> limiter : limiterSequence) {
            processedContextLimiters.addLast(limiter);
        }
        this.getContexts(processedContextLimiters).map(webParentElement -> webParentElement).forEachOrdered(contextConsumer);
        return this;
    }

    public WebPageContext addContextLimiter(@NotNull WebContextLimiter<?> limiter) {
        this.contextLimiters.addLast(limiter);
        return this;
    }

    public WebPageContext removeLastContextLimiter() {
        this.contextLimiters.removeLast();
        return this;
    }

    public WebPageContext removeContextLimiters() {
        this.contextLimiters.clear();
        return this;
    }

    @NotNull
    public <T extends WebPage> T getPage(@NotNull Class<T> pageClass) {
        WebPage pageInstance = ((WebPageService)this.environment.getService(WebPageService.class)).getPageInstanceByClass(pageClass);
        pageInstance.setWebBrowserDispatcher(this.dispatcher);
        pageInstance.setEnvironment(this.environment);
        this.activeWebPage = pageInstance;
        pageInstance.validatePageOpen();
        return (T)pageInstance;
    }

    @NotNull
    public WebPage getPage(@NotNull String pageName) {
        WebPage pageInstance = ((WebPageService)this.environment.getService(WebPageService.class)).getPageInstanceByName(pageName);
        pageInstance.setWebBrowserDispatcher(this.dispatcher);
        pageInstance.setEnvironment(this.environment);
        this.activeWebPage = pageInstance;
        pageInstance.validatePageOpen();
        return pageInstance;
    }

    @NotNull
    public WebPage getActivePage() {
        if (Objects.nonNull(this.activeWebPage)) {
            this.activeWebPage.validatePageOpen();
            return this.activeWebPage;
        }
        throw PageNotInitialized.exception((String)PageFactoryApiMessages.ACTIVE_PAGE_NOT_INITIALIZED.getMessage(new Object[0]));
    }

    public WebPageContext usePage(@NotNull String pageName) {
        this.getPage(pageName);
        return this;
    }

    public WebPageContext usePage(@NotNull Class<? extends WebPage> pageClass) {
        this.getPage(pageClass);
        return this;
    }

    @NotNull
    public String getPageSource() {
        return (String)((ExceptionMapperResult)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"BrowserGetActiveTabPageSource", (String[])new String[0]), () -> this.exceptionMapper.map(() -> {
            RemoteWebDriver instance = (RemoteWebDriver)this.dispatcher.getInstance(RemoteWebDriver.class);
            String pageSource = instance.getPageSource();
            return Objects.nonNull(pageSource) ? pageSource : "empty";
        }))).ifException(exception -> {
            throw exception;
        }).getResult();
    }

    @NotNull
    protected Stream<WebParentElement> getContexts(Deque<WebContextLimiter<?>> processedContextLimiters) {
        Stream activeContexts = Stream.of(this.getActivePage());
        if (processedContextLimiters.isEmpty()) {
            return activeContexts;
        }
        for (WebContextLimiter<?> processedContextLimiter : processedContextLimiters) {
            activeContexts = processedContextLimiter.getContexts(activeContexts);
        }
        return activeContexts;
    }
}

