/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.SeleniumWebDriverBinaryNotDeclared;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebSeleniumMessages;
import io.perfeccionista.framework.pagefactory.dispatcher.AbstractWebBrowserSeleniumDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.configuration.WebBrowserBinaryResolver;
import io.perfeccionista.framework.pagefactory.dispatcher.type.WebDriverType;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.nio.file.Path;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class LocalWebBrowserSeleniumDispatcher<T extends RemoteWebDriver, C extends MutableCapabilities>
extends AbstractWebBrowserSeleniumDispatcher<T, C> {
    protected WebBrowserBinaryResolver binaryResolver;

    public LocalWebBrowserSeleniumDispatcher(Environment environment, WebDriverType<T, C> webDriverType, WebBrowserBinaryResolver binaryResolver) {
        super(environment, webDriverType);
        this.binaryResolver = binaryResolver;
    }

    public WebBrowserDispatcher launch() {
        Path localFilePath = (Path)this.binaryResolver.getPath().orElseThrow(() -> SeleniumWebDriverBinaryNotDeclared.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_BINARY_NOT_DECLARED.getMessage(new Object[]{System.getProperty("os.name")})));
        System.setProperty(this.webDriverType.getLinkedProperty(), localFilePath.toString());
        this.instance = (RemoteWebDriver)ReflectionUtilsForClasses.newInstance(this.webDriverType.getWebDriverClass(), (Object[])new Object[]{this.options});
        this.setTimeouts();
        return this;
    }
}

