/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.SeleniumWebDriverInstanceNotStarted;
import io.perfeccionista.framework.exceptions.mapper.SeleniumExceptionMapper;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebSeleniumMessages;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.configuration.WebBrowserTimeouts;
import io.perfeccionista.framework.pagefactory.dispatcher.context.DefaultWebPageContext;
import io.perfeccionista.framework.pagefactory.dispatcher.context.WebPageContext;
import io.perfeccionista.framework.pagefactory.dispatcher.cookies.SeleniumWebBrowserCookiesDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.cookies.WebBrowserCookiesDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.executor.SeleniumWebBrowserOperationExecutor;
import io.perfeccionista.framework.pagefactory.dispatcher.executor.WebBrowserOperationExecutor;
import io.perfeccionista.framework.pagefactory.dispatcher.logs.SeleniumWebBrowserLogsDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.logs.WebBrowserLogsDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.SeleniumWebBrowserTabsDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.type.WebDriverType;
import io.perfeccionista.framework.pagefactory.dispatcher.window.SeleniumWebBrowserWindowDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.window.WebBrowserWindowDispatcher;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class AbstractWebBrowserSeleniumDispatcher<T extends RemoteWebDriver, C extends MutableCapabilities>
implements WebBrowserDispatcher {
    protected final Environment environment;
    protected final WebDriverType<T, C> webDriverType;
    protected WebBrowserTimeouts timeouts;
    protected WebExceptionMapper exceptionMapper;
    protected C options;
    protected T instance = null;
    protected WebPageContext context = null;
    protected WebBrowserOperationExecutor executor = null;
    protected WebBrowserCookiesDispatcher cookies = null;
    protected WebBrowserWindowDispatcher window = null;
    protected WebBrowserTabsDispatcher tabs = null;
    protected WebBrowserLogsDispatcher logs = null;
    protected boolean traceSearch = false;

    protected AbstractWebBrowserSeleniumDispatcher(Environment environment, WebDriverType<T, C> webDriverType) {
        this.environment = environment;
        this.webDriverType = webDriverType;
        this.exceptionMapper = new SeleniumExceptionMapper();
        this.options = webDriverType.getDefaultCapabilities();
        this.timeouts = new WebBrowserTimeouts();
    }

    public AbstractWebBrowserSeleniumDispatcher<T, C> withOptions(@NotNull C options) {
        this.options = options;
        return this;
    }

    public AbstractWebBrowserSeleniumDispatcher<T, C> withTimeouts(@NotNull WebBrowserTimeouts timeouts) {
        this.timeouts = timeouts;
        return this;
    }

    public AbstractWebBrowserSeleniumDispatcher<T, C> withExceptionMapper(@NotNull WebExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
        return this;
    }

    public AbstractWebBrowserSeleniumDispatcher<T, C> withTraceSearch(boolean traceSearch) {
        this.traceSearch = traceSearch;
        return this;
    }

    public WebBrowserDispatcher close() {
        if (this.instance != null) {
            if (this.instance.getSessionId() != null) {
                this.instance.getWindowHandles().forEach(handle -> this.instance.switchTo().window(handle).close());
            }
            try {
                this.instance.quit();
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
        this.instance = null;
        this.context = null;
        this.executor = null;
        this.cookies = null;
        this.window = null;
        this.tabs = null;
        this.logs = null;
        return this;
    }

    public WebExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public WebPageContext getWebPageContext() {
        this.checkWebDriverInstance();
        return Optional.ofNullable(this.context).orElseGet(() -> {
            this.context = new DefaultWebPageContext(this.environment, this, this.exceptionMapper);
            return this.context;
        });
    }

    public WebBrowserOperationExecutor executor() {
        this.checkWebDriverInstance();
        return Optional.ofNullable(this.executor).orElseGet(() -> {
            this.executor = this.traceSearch ? new SeleniumWebBrowserOperationExecutor(this.environment, (RemoteWebDriver)this.instance, this.exceptionMapper).withJsLogs() : new SeleniumWebBrowserOperationExecutor(this.environment, (RemoteWebDriver)this.instance, this.exceptionMapper);
            return this.executor;
        });
    }

    public WebBrowserCookiesDispatcher cookies() {
        this.checkWebDriverInstance();
        return Optional.ofNullable(this.cookies).orElseGet(() -> {
            this.cookies = new SeleniumWebBrowserCookiesDispatcher(this.environment, (RemoteWebDriver)this.instance, this.exceptionMapper);
            return this.cookies;
        });
    }

    public WebBrowserWindowDispatcher window() {
        this.checkWebDriverInstance();
        return Optional.ofNullable(this.window).orElseGet(() -> {
            this.window = new SeleniumWebBrowserWindowDispatcher(this.environment, (RemoteWebDriver)this.instance, this.exceptionMapper, this.executor());
            return this.window;
        });
    }

    public WebBrowserTabsDispatcher tabs() {
        this.checkWebDriverInstance();
        return Optional.ofNullable(this.tabs).orElseGet(() -> {
            this.tabs = new SeleniumWebBrowserTabsDispatcher(this.environment, (RemoteWebDriver)this.instance, this.exceptionMapper);
            return this.tabs;
        });
    }

    public WebBrowserLogsDispatcher logs() {
        this.checkWebDriverInstance();
        return Optional.ofNullable(this.logs).orElseGet(() -> {
            this.logs = new SeleniumWebBrowserLogsDispatcher(this.environment, (RemoteWebDriver)this.instance, this.exceptionMapper);
            return this.logs;
        });
    }

    public <T> T getInstance(Class<T> browserInstanceClass) {
        this.checkWebDriverInstance();
        return this.instance;
    }

    protected void checkWebDriverInstance() {
        if (this.instance == null) {
            throw SeleniumWebDriverInstanceNotStarted.exception(PageFactoryWebSeleniumMessages.WEB_DRIVER_INSTANCE_NOT_STARTED.getMessage(new Object[0]));
        }
    }

    protected void setTimeouts() {
        this.checkWebDriverInstance();
        this.instance.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        this.instance.manage().timeouts().pageLoadTimeout(this.timeouts.getOperationTimeout(), TimeUnit.MILLISECONDS);
        this.instance.manage().timeouts().setScriptTimeout(this.timeouts.getOperationTimeout(), TimeUnit.MILLISECONDS);
    }
}

