/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.utils;

import io.perfeccionista.framework.exceptions.ElementCast;
import io.perfeccionista.framework.exceptions.ElementNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.measurements.Order;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentElement;
import io.perfeccionista.framework.pagefactory.factory.proxy.frame.WebChildElementFrame;
import io.perfeccionista.framework.utils.CastUtils;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import io.perfeccionista.framework.utils.ReflectionUtilsForMethods;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class WebElementUtils {
    private WebElementUtils() {
    }

    @NotNull
    public static <T extends WebChildElement> T castWebChildElement(@NotNull WebChildElement elementToCast, @NotNull Class<T> castType) {
        if (CastUtils.isSubtypeOf((Object)elementToCast, castType)) {
            return (T)((WebChildElement)castType.cast(elementToCast));
        }
        throw ElementCast.exception((String)PageFactoryApiMessages.ELEMENT_CANNOT_BE_CASTED.getMessage(new Object[]{castType.getCanonicalName()})).addFirstAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(elementToCast));
    }

    @NotNull
    public static WebChildElementFrame castWebChildElementFrame(@NotNull WebChildElement elementToCast) {
        if (CastUtils.isSubtypeOf((Object)elementToCast, WebChildElementFrame.class)) {
            return (WebChildElementFrame)WebChildElementFrame.class.cast(elementToCast);
        }
        throw ElementCast.exception((String)PageFactoryApiMessages.ELEMENT_CANNOT_BE_CASTED.getMessage(new Object[]{WebChildElementFrame.class.getCanonicalName()})).addFirstAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(elementToCast));
    }

    public static Method getRequiredMethodByName(@NotNull String methodName, @NotNull Class<?> methodReturnType, @NotNull Class<? extends WebBlock> mappedBlockClass) {
        return WebElementUtils.getWebChildElementMethods(mappedBlockClass).stream().filter(method -> methodName.equals(method.getName())).filter(method -> methodReturnType.isAssignableFrom(method.getReturnType())).findFirst().orElseThrow(() -> ElementNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NOT_FOUND.getMessage(new Object[]{methodName})));
    }

    public static List<Method> getWebChildElementMethods(@NotNull Class<? extends WebParentElement> processedClass) {
        Predicate<Method> methodPredicate = method -> WebChildElement.class.isAssignableFrom(method.getReturnType()) && !method.isDefault() && !Modifier.isStatic(method.getModifiers()) && !WebBlock.class.equals(method.getDeclaringClass()) && !WebChildElement.class.equals(method.getDeclaringClass());
        HashSet methods = new HashSet();
        methods.addAll(ReflectionUtilsForMethods.findMethods(processedClass, methodPredicate));
        Deque inheritedParentInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebParentElement.class, processedClass, (Order)Order.DESC);
        for (Class inheritedParentInterface : inheritedParentInterfaces) {
            methods.addAll(ReflectionUtilsForMethods.findMethods((Class)inheritedParentInterface, methodPredicate));
        }
        return new ArrayList<Method>(methods);
    }
}

