/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class JsScrollTo
implements EndpointHandler<Void> {
    private final String scrollRoot;
    private double topIndent = 0.0;
    private double rightIndent = 0.0;
    private double bottomIndent = 0.0;
    private double leftIndent = 0.0;
    private Duration delay = Duration.ZERO;

    public JsScrollTo() {
        this.scrollRoot = "document.documentElement";
    }

    public JsScrollTo setTopIndent(double topIndent) {
        this.topIndent = topIndent;
        return this;
    }

    public JsScrollTo setRightIndent(double rightIndent) {
        this.rightIndent = rightIndent;
        return this;
    }

    public JsScrollTo setBottomIndent(double bottomIndent) {
        this.bottomIndent = bottomIndent;
        return this;
    }

    public JsScrollTo setLeftIndent(double leftIndent) {
        this.leftIndent = leftIndent;
        return this;
    }

    public JsScrollTo setDelay(@NotNull Duration delay) {
        this.delay = delay;
        return this;
    }

    public Void handle(Object endpoint) {
        return null;
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode scrollToInvocation = JsonUtils.createObjectNode().put("name", "perfeccionista.web.js.ScrollTo").put("script", "js/ScrollTo.js");
        ObjectNode options = JsonUtils.createObjectNode().put("scrollRoot", this.scrollRoot).put("topIndent", this.topIndent).put("rightIndent", this.rightIndent).put("bottomIndent", this.bottomIndent).put("leftIndent", this.leftIndent);
        if (!this.delay.isZero() && !this.delay.isNegative()) {
            options.put("delay", this.getDelayInMilliseconds());
        }
        scrollToInvocation.set("options", (JsonNode)options);
        return scrollToInvocation;
    }

    protected long getDelayInMilliseconds() {
        return this.delay.getSeconds() * 1000L + (long)(this.delay.getNano() / 1000000);
    }
}

