/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.UnsupportedScreenshotMimeType;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.screenshots.JpegScreenshot;
import io.perfeccionista.framework.screenshots.PngScreenshot;
import io.perfeccionista.framework.screenshots.Screenshot;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;

public class JsGetScreenshot
implements EndpointHandler<Screenshot> {
    protected String mimeType = "image/png";
    protected ObjectNode options = JsonUtils.createObjectNode();

    public JsGetScreenshot setMimeType(@NotNull String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public JsGetScreenshot setOptions(@NotNull ObjectNode options) {
        this.options = options;
        return this;
    }

    public Screenshot handle(Object endpoint) {
        String mimeType;
        String dataUrl = endpoint.toString();
        byte[] raw = Base64.getDecoder().decode(dataUrl.substring(dataUrl.indexOf(44) + 1));
        switch (mimeType = dataUrl.substring(dataUrl.indexOf(58) + 1, dataUrl.indexOf(59))) {
            case "image/png": {
                return PngScreenshot.from((byte[])raw);
            }
            case "image/jpeg": {
                return JpegScreenshot.from((byte[])raw);
            }
        }
        throw UnsupportedScreenshotMimeType.exception((String)PageFactoryApiMessages.SCREENSHOT_MIME_TYPE_NOT_SUPPORTED.getMessage(new Object[]{mimeType}));
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("name", "perfeccionista.web.js.GetScreenshot").put("script", "js/GetScreenshot.js");
        this.options.put("requiredMimeType", this.mimeType);
        rootNode.set("options", (JsonNode)this.options);
        return rootNode;
    }
}

