/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.color.Color;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class JsGetColor
implements EndpointHandler<Color> {
    private final String cssProperty;

    public JsGetColor(@NotNull String cssProperty) {
        this.cssProperty = cssProperty;
    }

    public Color handle(Object endpoint) {
        JsonNode colorNode = JsonUtils.parseJsonNode((String)endpoint.toString());
        return Color.of((int)colorNode.get("r").asInt(), (int)colorNode.get("g").asInt(), (int)colorNode.get("b").asInt(), (double)colorNode.get("alpha").asDouble());
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("name", "perfeccionista.web.js.GetColor").put("script", "js/GetColor.js");
        ObjectNode options = JsonUtils.createObjectNode().put("cssProperty", this.cssProperty);
        rootNode.set("options", (JsonNode)options);
        return rootNode;
    }
}

