/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class WebLocatorProcessingResult
implements JsonSerializable {
    private final long index;
    private final boolean found;
    private final String hash;
    private final Boolean hashCorrect;

    protected WebLocatorProcessingResult(long index, boolean found, @Nullable String hash, @Nullable Boolean hashCorrect) {
        this.index = index;
        this.found = found;
        this.hashCorrect = hashCorrect;
        this.hash = hash;
    }

    public static WebLocatorProcessingResult of(long index, boolean found, @Nullable String hash, @Nullable Boolean hashCorrect) {
        return new WebLocatorProcessingResult(index, found, hash, hashCorrect);
    }

    public long getIndex() {
        return this.index;
    }

    public boolean isFound() {
        return this.found;
    }

    public Optional<String> getHash() {
        return Optional.ofNullable(this.hash);
    }

    public Optional<Boolean> getHashCorrect() {
        return Optional.ofNullable(this.hashCorrect);
    }

    public JsonNode toJson() {
        return JsonUtils.createObjectNode().put("index", this.index).put("found", this.found).put("hash", this.hash).put("hashCorrect", this.hashCorrect);
    }
}

